/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.bamboo;

import com.gradle.develocity.bamboo.MavenCoordinates;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

final class MavenExtensions {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenExtensions.class);
    private static final XPath XPATH = XPathFactory.newInstance().newXPath();
    private static final String EXTENSION_XPATH_EXPR = "/extensions/extension[groupId = '%s' and artifactId = '%s']";
    @Nullable
    private final Document document;

    private MavenExtensions(@Nullable Document document) {
        this.document = document;
    }

    static MavenExtensions empty() {
        return new MavenExtensions(null);
    }

    static MavenExtensions fromFile(@NotNull File extensionsFile) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(extensionsFile);
            document.normalizeDocument();
            return new MavenExtensions(document);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.warn("Failed to parse extensions file: {}", (Object)extensionsFile.getAbsolutePath(), (Object)e);
            return MavenExtensions.empty();
        }
    }

    boolean hasExtension(@Nullable MavenCoordinates coordinates) {
        if (this.document == null || coordinates == null) {
            return false;
        }
        String expr = String.format(EXTENSION_XPATH_EXPR, coordinates.groupId(), coordinates.artifactId());
        try {
            XPathExpression exprCompiled = XPATH.compile(expr);
            NodeList extension = (NodeList)exprCompiled.evaluate(this.document, XPathConstants.NODESET);
            return extension != null && extension.getLength() > 0;
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Could not apply XPath expression: {}", (Object)expr, (Object)e);
            return false;
        }
    }
}

