/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.bamboo;

import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableSet;
import com.gradle.develocity.bamboo.AbstractBuildScanInjector;
import com.gradle.develocity.bamboo.BuildTool;
import com.gradle.develocity.bamboo.Classpath;
import com.gradle.develocity.bamboo.DevelocityAccessKeyExporter;
import com.gradle.develocity.bamboo.DevelocityMavenOptsSetter;
import com.gradle.develocity.bamboo.MavenCoordinates;
import com.gradle.develocity.bamboo.MavenEmbeddedResources;
import com.gradle.develocity.bamboo.MavenExtensions;
import com.gradle.develocity.bamboo.SystemProperty;
import com.gradle.develocity.bamboo.config.MavenConfiguration;
import com.gradle.develocity.bamboo.config.PersistentConfiguration;
import com.gradle.develocity.bamboo.config.PersistentConfigurationManager;
import com.gradle.develocity.bamboo.utils.Collections;
import com.gradle.develocity.bamboo.utils.StringPredicates;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MavenBuildScanInjector
extends AbstractBuildScanInjector<MavenConfiguration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenBuildScanInjector.class);
    private static final String MAVEN_3_PLUGIN_KEY = "com.atlassian.bamboo.plugins.maven:task.builder.mvn3";
    public static final String ARTIFACTORY_MAVEN_3_TASK_KEY_SUFFIX = "maven3Task";
    private static final Set<Predicate<String>> MAVEN_3_BUILDERS = ImmutableSet.of(StringPredicates.eq("com.atlassian.bamboo.plugins.maven:task.builder.mvn3"), StringPredicates.endsWith("maven3Task"));
    private static final MavenCoordinates DEVELOCITY_EXTENSION_MAVEN_COORDINATES = new MavenCoordinates("com.gradle", "gradle-enterprise-maven-extension");
    private static final MavenCoordinates CCUD_EXTENSION_MAVEN_COORDINATES = new MavenCoordinates("com.gradle", "common-custom-user-data-maven-extension");
    private final DevelocityAccessKeyExporter accessKeyExporter;
    private final List<DevelocityMavenOptsSetter> mavenOptsSetters;
    private final MavenEmbeddedResources mavenEmbeddedResources = new MavenEmbeddedResources();

    @Autowired
    public MavenBuildScanInjector(@ComponentImport BuildLoggerManager buildLoggerManager, PersistentConfigurationManager configurationManager, DevelocityAccessKeyExporter accessKeyExporter, List<DevelocityMavenOptsSetter> mavenOptsSetters) {
        super(buildLoggerManager, configurationManager);
        this.accessKeyExporter = accessKeyExporter;
        this.mavenOptsSetters = Collections.sortedByOrder(mavenOptsSetters);
    }

    @Override
    public boolean isSupported(RuntimeTaskDefinition task) {
        return MavenBuildScanInjector.anyMatch(MAVEN_3_BUILDERS, task);
    }

    @Override
    public MavenConfiguration buildToolConfiguration(PersistentConfiguration configuration) {
        return MavenConfiguration.of(configuration);
    }

    @Override
    public BuildTool buildTool() {
        return BuildTool.MAVEN;
    }

    @Override
    public void inject(BuildContext buildContext) {
        Collection<RuntimeTaskDefinition> mavenBuilders = this.getSupportedTasks(buildContext);
        if (mavenBuilders.isEmpty()) {
            return;
        }
        this.inject(buildContext, mavenBuilders);
    }

    private void inject(BuildContext buildContext, Collection<RuntimeTaskDefinition> tasks) {
        MavenConfiguration config = this.loadConfiguration().orElse(null);
        if (config == null || config.isDisabled()) {
            LOGGER.debug("Develocity Maven auto-injection is disabled");
            return;
        }
        MavenExtensions existingMavenExtensions = MavenBuildScanInjector.getExistingMavenExtensions(buildContext);
        Classpath classpath = new Classpath();
        ArrayList<SystemProperty> systemProperties = new ArrayList<SystemProperty>();
        if (!existingMavenExtensions.hasExtension(DEVELOCITY_EXTENSION_MAVEN_COORDINATES)) {
            classpath.add(this.mavenEmbeddedResources.copy(MavenEmbeddedResources.Resource.DEVELOCITY_EXTENSION));
            systemProperties.add(new SystemProperty("gradle.scan.uploadInBackground", "false"));
            systemProperties.add(new SystemProperty("gradle.enterprise.url", config.server));
            if (config.allowUntrustedServer) {
                systemProperties.add(new SystemProperty("gradle.enterprise.allowUntrustedServer", "true"));
            }
        }
        if (config.injectCcudExtension && !existingMavenExtensions.hasExtension(CCUD_EXTENSION_MAVEN_COORDINATES)) {
            classpath.add(this.mavenEmbeddedResources.copy(MavenEmbeddedResources.Resource.CCUD_EXTENSION));
        }
        if (classpath.isNotEmpty()) {
            String mavenExtClasspath = classpath.asString();
            LOGGER.debug("Maven classpath: {}", (Object)mavenExtClasspath);
            this.registerDevelocityResources(buildContext, classpath.files());
            systemProperties.add(new SystemProperty("maven.ext.class.path", mavenExtClasspath));
            tasks.forEach(task -> this.mavenOptsSetters.stream().filter(setter -> setter.applies((RuntimeTaskDefinition)task)).findFirst().ifPresent(setter -> setter.apply((RuntimeTaskDefinition)task, (List<SystemProperty>)systemProperties)));
        } else {
            LOGGER.debug("Maven classpath is empty due to an existing Develocity and CCUD extension");
        }
        this.setupBuildScansLogInterceptor(buildContext);
        this.accessKeyExporter.exportDevelocityAccessKey(buildContext, tasks);
        LOGGER.debug("Develocity Maven auto-injection completed");
    }

    private static MavenExtensions getExistingMavenExtensions(BuildContext buildContext) {
        for (String checkoutLocation : buildContext.getCheckoutLocation().values()) {
            File checkoutDirectory = new File(checkoutLocation);
            File extensionsFile = new File(checkoutDirectory, ".mvn/extensions.xml");
            if (extensionsFile.exists()) {
                LOGGER.debug("Found extensions file: {}", (Object)extensionsFile);
                return MavenExtensions.fromFile(extensionsFile);
            }
            LOGGER.debug("Extensions file not found: {}", (Object)extensionsFile);
        }
        return MavenExtensions.empty();
    }
}

