/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.bamboo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.commons.io.FileUtils;

public final class GradleEmbeddedResources {
    private static final String INIT_SCRIPT_NAME = "develocity-init-script.gradle";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    File copyInitScript(String home) {
        try (InputStream is = GradleEmbeddedResources.class.getResourceAsStream(String.format("/develocity/gradle/%s", INIT_SCRIPT_NAME));){
            if (is == null) {
                throw new IOException("Embedded Develocity init script not found");
            }
            File initScript = GradleEmbeddedResources.initScript(home);
            initScript.getParentFile().mkdirs();
            Files.copy(is, initScript.toPath(), StandardCopyOption.REPLACE_EXISTING);
            File file = initScript;
            return file;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static void deleteInitScript(String home) {
        File initScript = GradleEmbeddedResources.initScript(home);
        if (initScript.exists()) {
            FileUtils.deleteQuietly((File)initScript);
        }
    }

    private static File initScript(String home) {
        return new File(home, String.format(".gradle/init.d/%s", INIT_SCRIPT_NAME));
    }
}

