/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.bamboo;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.CustomPreBuildAction;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.task.AbstractBuildTask;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.gradle.develocity.bamboo.BuildScanInjector;
import com.gradle.develocity.bamboo.config.BuildToolConfiguration;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevelocityPreBuildAction
extends AbstractBuildTask
implements CustomPreBuildAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(DevelocityPreBuildAction.class);
    private final List<BuildScanInjector<? extends BuildToolConfiguration>> injectors;
    private final BuildLoggerManager buildLoggerManager;

    public DevelocityPreBuildAction(List<BuildScanInjector<? extends BuildToolConfiguration>> injectors, @ComponentImport BuildLoggerManager buildLoggerManager) {
        this.injectors = injectors;
        this.buildLoggerManager = buildLoggerManager;
    }

    public ErrorCollection validate(BuildConfiguration configuration) {
        return new SimpleErrorCollection();
    }

    @NotNull
    public BuildContext call() {
        for (BuildScanInjector<? extends BuildToolConfiguration> injector : this.injectors) {
            try {
                injector.inject(this.buildContext);
            }
            catch (Exception e) {
                LOGGER.error("Develocity {} auto-injection failed", (Object)injector.buildTool().displayName(), (Object)e);
                this.addErrorToBuildLog(injector, e);
            }
        }
        return this.buildContext;
    }

    private void addErrorToBuildLog(BuildScanInjector injector, Exception ex) {
        try {
            String message = String.format("Develocity %s auto-injection failed", injector.buildTool().displayName());
            this.buildLoggerManager.getLogger((ResultKey)this.buildContext.getPlanResultKey()).addErrorLogEntry(message, (Throwable)ex);
        }
        catch (Exception e) {
            LOGGER.error("Unable to add error log entry", (Throwable)e);
        }
    }
}

