/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.bamboo;

import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.gradle.develocity.bamboo.SystemProperty;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.Ordered;

public interface DevelocityMavenOptsSetter
extends Ordered {
    public boolean applies(RuntimeTaskDefinition var1);

    public void apply(RuntimeTaskDefinition var1, List<SystemProperty> var2);

    public static String mergeMavenOpts(@Nullable String existingMavenOpts, List<SystemProperty> systemProperties) {
        Stream<String> develocityMavenOpts = systemProperties.stream().map(SystemProperty::asString);
        if (StringUtils.isBlank((CharSequence)existingMavenOpts)) {
            return DevelocityMavenOptsSetter.joinOnSpace(develocityMavenOpts);
        }
        Set keys = systemProperties.stream().map(SystemProperty::key).collect(Collectors.toSet());
        Stream<String> filteredExistingMavenOpts = DevelocityMavenOptsSetter.splitOnSpace(existingMavenOpts).filter(v -> keys.stream().noneMatch(v::contains));
        return DevelocityMavenOptsSetter.joinOnSpace(Stream.concat(filteredExistingMavenOpts, develocityMavenOpts));
    }

    public static Stream<String> splitOnSpace(String value) {
        return Arrays.stream(value.split(" "));
    }

    public static String joinOnSpace(Stream<String> stream) {
        return stream.collect(Collectors.joining(" "));
    }
}

