/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.bamboo;

import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.gradle.develocity.bamboo.EnvironmentVariableSetter;
import com.gradle.develocity.bamboo.utils.Collections;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DevelocityAccessKeyExporter {
    private final List<EnvironmentVariableSetter> environmentVariableSetters;

    @Autowired
    public DevelocityAccessKeyExporter(List<EnvironmentVariableSetter> environmentVariableSetters) {
        this.environmentVariableSetters = Collections.sortedByOrder(environmentVariableSetters);
    }

    public void exportDevelocityAccessKey(BuildContext buildContext, Collection<RuntimeTaskDefinition> tasks) {
        BambooIterables.stream((Iterable)buildContext.getVariableContext().getPasswordVariables()).filter(this::isDevelocityAccessKey).findFirst().map(VariableDefinitionContext::getValue).ifPresent(accessKey -> tasks.forEach(task -> this.environmentVariableSetters.stream().filter(setter -> setter.applies((RuntimeTaskDefinition)task)).findFirst().ifPresent(setter -> setter.apply((RuntimeTaskDefinition)task, "GRADLE_ENTERPRISE_ACCESS_KEY", (String)accessKey))));
    }

    private boolean isDevelocityAccessKey(VariableDefinitionContext context) {
        return "develocity.secret.accessKey".equals(context.getKey());
    }
}

