/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.bamboo;

import com.atlassian.bamboo.build.ViewBuildResults;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class BuildScansAction
extends ViewBuildResults {
    private final List<String> buildScans = new ArrayList<String>();

    public String execute() throws Exception {
        String superResult = super.execute();
        if ("error".equals(superResult)) {
            return "error";
        }
        BuildResultsSummary resultsSummary = this.getBuildResultsSummary();
        if (resultsSummary == null) {
            return "error";
        }
        this.populateBuildScans((ResultsSummary)resultsSummary);
        return superResult;
    }

    private void populateBuildScans(ResultsSummary resultsSummary) {
        String allBuildScans = (String)resultsSummary.getCustomBuildData().get("buildScans");
        if (StringUtils.isNotBlank((CharSequence)allBuildScans)) {
            this.buildScans.addAll(Arrays.asList(allBuildScans.split(",")));
        }
    }

    public List<String> getBuildScans() {
        return this.buildScans;
    }
}

