/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.bamboo;

import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CurrentResult;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BuildScanCollector
implements Consumer<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildScanCollector.class);
    private final BuildContext buildContext;

    BuildScanCollector(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    @Override
    public void accept(String buildScan) {
        CurrentResult currentResult = this.buildContext.getCurrentResult();
        if (currentResult != null) {
            LOGGER.debug("A build scan has been found: {}", (Object)buildScan);
            currentResult.getCustomBuildData().merge("buildScans", buildScan, BuildScanCollector::concat);
        }
    }

    private static String concat(String existingBuildScans, String newBuildScan) {
        return String.join((CharSequence)",", existingBuildScans, newBuildScan);
    }
}

