/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.bamboo;

import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.google.common.annotations.VisibleForTesting;
import com.gradle.develocity.bamboo.DevelocityMavenOptsSetter;
import com.gradle.develocity.bamboo.SystemProperty;
import com.gradle.develocity.bamboo.utils.TaskPredicates;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.stereotype.Component;

@Component
public class ArtifactoryMaven3TaskMavenOptsSetter
implements DevelocityMavenOptsSetter {
    @VisibleForTesting
    static final String MAVEN_OPTS_KEY = "builder.artifactoryMaven3Builder.mavenOpts";
    private static final Predicate<RuntimeTaskDefinition> ARTIFACTORY_MAVEN_3_TASK_TESTER = TaskPredicates.artifactoryMaven3TaskTester();

    @Override
    public boolean applies(RuntimeTaskDefinition task) {
        return ARTIFACTORY_MAVEN_3_TASK_TESTER.test(task);
    }

    public int getOrder() {
        return 0;
    }

    @Override
    public void apply(RuntimeTaskDefinition task, List<SystemProperty> systemProperties) {
        Map configuration = task.getConfiguration();
        String existingMavenOpts = (String)configuration.get(MAVEN_OPTS_KEY);
        String updatedMavenOpts = DevelocityMavenOptsSetter.mergeMavenOpts(existingMavenOpts, systemProperties);
        configuration.put(MAVEN_OPTS_KEY, updatedMavenOpts);
    }
}

