/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.bamboo;

import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.gradle.develocity.bamboo.EnvironmentVariableSetter;
import com.gradle.develocity.bamboo.utils.EnvironmentVariables;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

abstract class AbstractEnvironmentVariableSetter
implements EnvironmentVariableSetter {
    private final String environmentVariablesKey;

    AbstractEnvironmentVariableSetter(String environmentVariablesKey) {
        this.environmentVariablesKey = environmentVariablesKey;
    }

    @Override
    public void apply(RuntimeTaskDefinition task, String name, String value) {
        Map configuration = task.getConfiguration();
        String currentEnvironment = StringUtils.trimToNull((String)((String)configuration.get(this.environmentVariablesKey)));
        String additionalEnvironmentVariable = String.format("%s=%s", name, EnvironmentVariables.quoteIfNeeded(value));
        String updatedEnvironment = currentEnvironment == null ? additionalEnvironmentVariable : StringUtils.join((Object[])new String[]{currentEnvironment, additionalEnvironmentVariable}, (char)' ');
        configuration.put(this.environmentVariablesKey, updatedEnvironment);
    }
}

