/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.bamboo;

import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableSet;
import com.gradle.enterprise.bamboo.AbstractBuildScanInjector;
import com.gradle.enterprise.bamboo.BuildTool;
import com.gradle.enterprise.bamboo.Classpath;
import com.gradle.enterprise.bamboo.GradleEnterpriseAccessKeyExporter;
import com.gradle.enterprise.bamboo.GradleEnterpriseMavenOptsSetter;
import com.gradle.enterprise.bamboo.MavenEmbeddedResources;
import com.gradle.enterprise.bamboo.SystemProperty;
import com.gradle.enterprise.bamboo.config.MavenConfiguration;
import com.gradle.enterprise.bamboo.config.PersistentConfiguration;
import com.gradle.enterprise.bamboo.config.PersistentConfigurationManager;
import com.gradle.enterprise.bamboo.utils.Collections;
import com.gradle.enterprise.bamboo.utils.StringPredicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MavenBuildScanInjector
extends AbstractBuildScanInjector<MavenConfiguration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenBuildScanInjector.class);
    private static final String MAVEN_3_PLUGIN_KEY = "com.atlassian.bamboo.plugins.maven:task.builder.mvn3";
    public static final String ARTIFACTORY_MAVEN_3_TASK_KEY_SUFFIX = "maven3Task";
    private static final Set<Predicate<String>> MAVEN_3_BUILDERS = ImmutableSet.of(StringPredicates.eq("com.atlassian.bamboo.plugins.maven:task.builder.mvn3"), StringPredicates.endsWith("maven3Task"));
    private final GradleEnterpriseAccessKeyExporter accessKeyExporter;
    private final List<GradleEnterpriseMavenOptsSetter> mavenOptsSetters;
    private final MavenEmbeddedResources mavenEmbeddedResources = new MavenEmbeddedResources();

    @Autowired
    public MavenBuildScanInjector(@ComponentImport BuildLoggerManager buildLoggerManager, PersistentConfigurationManager configurationManager, GradleEnterpriseAccessKeyExporter accessKeyExporter, List<GradleEnterpriseMavenOptsSetter> mavenOptsSetters) {
        super(buildLoggerManager, configurationManager);
        this.accessKeyExporter = accessKeyExporter;
        this.mavenOptsSetters = Collections.sortedByOrder(mavenOptsSetters);
    }

    @Override
    public boolean isSupported(RuntimeTaskDefinition task) {
        return MavenBuildScanInjector.anyMatch(MAVEN_3_BUILDERS, task);
    }

    @Override
    public MavenConfiguration buildToolConfiguration(PersistentConfiguration configuration) {
        return MavenConfiguration.of(configuration);
    }

    @Override
    public BuildTool buildTool() {
        return BuildTool.MAVEN;
    }

    @Override
    public void inject(BuildContext buildContext) {
        Collection<RuntimeTaskDefinition> mavenBuilders = this.getSupportedTasks(buildContext);
        if (mavenBuilders.isEmpty()) {
            return;
        }
        this.inject(buildContext, mavenBuilders);
    }

    private void inject(BuildContext buildContext, Collection<RuntimeTaskDefinition> tasks) {
        MavenConfiguration config = this.loadConfiguration().orElse(null);
        if (config == null || config.isDisabled()) {
            LOGGER.debug("Gradle Enterprise Maven auto-injection is disabled");
            return;
        }
        Classpath classpath = new Classpath();
        classpath.add(this.mavenEmbeddedResources.copy(MavenEmbeddedResources.Resource.GE_EXTENSION));
        if (config.injectCcudExtension) {
            classpath.add(this.mavenEmbeddedResources.copy(MavenEmbeddedResources.Resource.CCUD_EXTENSION));
        }
        String mavenExtClasspath = classpath.asString();
        LOGGER.debug("Maven classpath: {}", (Object)mavenExtClasspath);
        this.registerGradleEnterpriseResources(buildContext, classpath.files());
        ArrayList<SystemProperty> systemProperties = new ArrayList<SystemProperty>();
        systemProperties.add(new SystemProperty("maven.ext.class.path", mavenExtClasspath));
        systemProperties.add(new SystemProperty("gradle.scan.uploadInBackground", "false"));
        systemProperties.add(new SystemProperty("gradle.enterprise.url", config.server));
        if (config.allowUntrustedServer) {
            systemProperties.add(new SystemProperty("gradle.enterprise.allowUntrustedServer", "true"));
        }
        tasks.forEach(task -> this.mavenOptsSetters.stream().filter(setter -> setter.applies((RuntimeTaskDefinition)task)).findFirst().ifPresent(setter -> setter.apply((RuntimeTaskDefinition)task, (List<SystemProperty>)systemProperties)));
        this.setupBuildScansLogInterceptor(buildContext);
        this.accessKeyExporter.exportGradleEnterpriseAccessKey(buildContext, tasks);
        LOGGER.debug("Gradle Enterprise Maven auto-injection completed");
    }
}

