/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.bamboo;

import com.atlassian.bamboo.build.CustomBuildProcessor;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CurrentResult;
import com.atlassian.bamboo.v2.build.task.AbstractBuildTask;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradleEnterpriseBuildProcessor
extends AbstractBuildTask
implements CustomBuildProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(GradleEnterpriseBuildProcessor.class);

    @NotNull
    public BuildContext call() {
        this.registeredGradleEnterpriseResources().stream().map(File::new).forEach(this::delete);
        return this.buildContext;
    }

    private Collection<String> registeredGradleEnterpriseResources() {
        CurrentResult currentResult = this.buildContext.getCurrentResult();
        if (currentResult == null) {
            return Collections.emptyList();
        }
        String resources = (String)currentResult.getCustomBuildData().get("gradleEnterprise.resources");
        if (StringUtils.isBlank((CharSequence)resources)) {
            LOGGER.debug("No registered Gradle Enterprise resources for the build: {}", (Object)this.buildContext.getPlanResultKey().getKey());
            return Collections.emptyList();
        }
        return Arrays.asList(resources.split(","));
    }

    private void delete(File file) {
        if (!file.exists()) {
            LOGGER.error("Registered Gradle Enterprise resource not found: {}", (Object)file.getAbsolutePath());
            return;
        }
        boolean deleted = FileUtils.deleteQuietly((File)file);
        if (!deleted) {
            LOGGER.warn("Unable to delete registered Gradle Enterprise resource: {}", (Object)file.getAbsolutePath());
        }
    }
}

