/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.bamboo;

import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.gradle.enterprise.bamboo.EnvironmentVariableSetter;
import com.gradle.enterprise.bamboo.utils.Collections;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GradleEnterpriseAccessKeyExporter {
    private final List<EnvironmentVariableSetter> environmentVariableSetters;

    @Autowired
    public GradleEnterpriseAccessKeyExporter(List<EnvironmentVariableSetter> environmentVariableSetters) {
        this.environmentVariableSetters = Collections.sortedByOrder(environmentVariableSetters);
    }

    public void exportGradleEnterpriseAccessKey(BuildContext buildContext, Collection<RuntimeTaskDefinition> tasks) {
        BambooIterables.stream((Iterable)buildContext.getVariableContext().getPasswordVariables()).filter(this::isGradleEnterpriseAccessKey).findFirst().map(VariableDefinitionContext::getValue).ifPresent(accessKey -> tasks.forEach(task -> this.environmentVariableSetters.stream().filter(setter -> setter.applies((RuntimeTaskDefinition)task)).findFirst().ifPresent(setter -> setter.apply((RuntimeTaskDefinition)task, "GRADLE_ENTERPRISE_ACCESS_KEY", (String)accessKey))));
    }

    private boolean isGradleEnterpriseAccessKey(VariableDefinitionContext context) {
        return "gradleEnterprise.secret.accessKey".equals(context.getKey());
    }
}

