/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.bamboo;

import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.gradle.enterprise.bamboo.ResultsSummaryUtils;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public class BuildScansAvailableCondition
implements Condition {
    private ResultsSummaryManager resultsSummaryManager;

    public void init(Map<String, String> context) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        String buildKey = (String)ObjectUtils.firstNonNull((Object[])new String[]{(String)context.get("planKey"), (String)context.get("buildKey")});
        String buildNumber = (String)context.get("buildNumber");
        if (buildKey == null || buildNumber == null) {
            return false;
        }
        PlanResultKey planResultKey = PlanKeys.getPlanResultKey((String)buildKey, (int)Integer.parseInt(buildNumber));
        ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(planResultKey);
        return ResultsSummaryUtils.hasBuildScans(resultsSummary);
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }
}

