/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.bamboo.config;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.gradle.enterprise.bamboo.config.PersistentConfiguration;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PersistentConfigurationManager {
    private static final String KEY = "com.gradle.bamboo.plugins.ge.config";
    private final BandanaManager bandanaManager;

    @Autowired
    public PersistentConfigurationManager(@ComponentImport BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public void save(PersistentConfiguration configuration) {
        this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, KEY, (Object)configuration);
    }

    public Optional<PersistentConfiguration> load() {
        return Optional.ofNullable((PersistentConfiguration)this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, KEY));
    }
}

