/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.bamboo;

import com.atlassian.bamboo.chains.StageExecution;
import com.atlassian.bamboo.chains.plugins.PreJobAction;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.gradle.enterprise.bamboo.BuildScanInjector;
import com.gradle.enterprise.bamboo.config.BuildToolConfiguration;
import com.gradle.enterprise.bamboo.config.PersistentConfiguration;
import com.gradle.enterprise.bamboo.config.PersistentConfigurationManager;
import com.gradle.enterprise.bamboo.config.UsernameAndPasswordCredentialsProvider;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradleEnterprisePreJobAction
implements PreJobAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(GradleEnterprisePreJobAction.class);
    private static final String PASSWORD = "password";
    private final PersistentConfigurationManager configurationManager;
    private final UsernameAndPasswordCredentialsProvider credentialsProvider;
    private final List<BuildScanInjector<? extends BuildToolConfiguration>> injectors;

    public GradleEnterprisePreJobAction(PersistentConfigurationManager configurationManager, UsernameAndPasswordCredentialsProvider credentialsProvider, List<BuildScanInjector<? extends BuildToolConfiguration>> injectors) {
        this.configurationManager = configurationManager;
        this.credentialsProvider = credentialsProvider;
        this.injectors = injectors;
    }

    public void execute(@NotNull StageExecution stageExecution, @NotNull BuildContext buildContext) {
        PersistentConfiguration configuration = this.configurationManager.load().orElse(null);
        if (configuration == null) {
            return;
        }
        String sharedCredentialName = configuration.getSharedCredentialName();
        if (StringUtils.isBlank((CharSequence)sharedCredentialName)) {
            return;
        }
        CredentialsData data = this.credentialsProvider.findByName(sharedCredentialName).orElse(null);
        if (data == null) {
            LOGGER.warn("Shared credentials with the name {} are not found. Environment variable {} will not be set", (Object)sharedCredentialName, (Object)"GRADLE_ENTERPRISE_ACCESS_KEY");
            return;
        }
        String accessKey = (String)data.getConfiguration().get(PASSWORD);
        if (StringUtils.isBlank((CharSequence)accessKey)) {
            LOGGER.warn("Shared credentials with the name {} do not have password set. Environment variable {} will not be set", (Object)sharedCredentialName, (Object)"GRADLE_ENTERPRISE_ACCESS_KEY");
            return;
        }
        this.injectors.stream().filter(i -> i.hasSupportedTasks(buildContext)).map(i -> i.buildToolConfiguration(configuration)).filter(BuildToolConfiguration::isEnabled).findFirst().ifPresent(__ -> buildContext.getVariableContext().addLocalVariable("gradleEnterprise.secret.accessKey", accessKey));
    }
}

