/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.bamboo;

import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.gradle.enterprise.bamboo.SystemProperty;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.Ordered;

public interface GradleEnterpriseMavenOptsSetter
extends Ordered {
    public boolean applies(RuntimeTaskDefinition var1);

    public void apply(RuntimeTaskDefinition var1, List<SystemProperty> var2);

    public static String mergeMavenOpts(@Nullable String existingMavenOpts, List<SystemProperty> systemProperties) {
        Stream<String> geMavenOpts = systemProperties.stream().map(SystemProperty::asString);
        if (StringUtils.isBlank((CharSequence)existingMavenOpts)) {
            return GradleEnterpriseMavenOptsSetter.joinOnSpace(geMavenOpts);
        }
        Set keys = systemProperties.stream().map(SystemProperty::key).collect(Collectors.toSet());
        Stream<String> filteredExistingMavenOpts = GradleEnterpriseMavenOptsSetter.splitOnSpace(existingMavenOpts).filter(v -> keys.stream().noneMatch(v::contains));
        return GradleEnterpriseMavenOptsSetter.joinOnSpace(Stream.concat(filteredExistingMavenOpts, geMavenOpts));
    }

    public static Stream<String> splitOnSpace(String value) {
        return Arrays.stream(value.split(" "));
    }

    public static String joinOnSpace(Stream<String> stream) {
        return stream.collect(Collectors.joining(" "));
    }
}

