/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.bamboo;

import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.gradle.enterprise.bamboo.GradleEnterpriseMavenOptsSetter;
import com.gradle.enterprise.bamboo.SystemProperty;
import com.gradle.enterprise.bamboo.utils.EnvironmentVariables;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultMavenOptsSetter
implements GradleEnterpriseMavenOptsSetter {
    @VisibleForTesting
    static final String ENVIRONMENT_VARIABLES_KEY = "environmentVariables";
    private static final String MAVEN_OPTS = "MAVEN_OPTS";
    private final EnvironmentVariableAccessor environmentVariableAccessor;

    @Autowired
    public DefaultMavenOptsSetter(@ComponentImport EnvironmentVariableAccessor environmentVariableAccessor) {
        this.environmentVariableAccessor = environmentVariableAccessor;
    }

    @Override
    public boolean applies(RuntimeTaskDefinition task) {
        return true;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void apply(RuntimeTaskDefinition task, List<SystemProperty> systemProperties) {
        Map configuration = task.getConfiguration();
        String currentEnvironment = (String)configuration.get(ENVIRONMENT_VARIABLES_KEY);
        HashMap<String, String> environment = new HashMap<String, String>(this.environmentVariableAccessor.splitEnvironmentAssignments(currentEnvironment));
        String existingMavenOpts = (String)environment.remove(MAVEN_OPTS);
        environment.put(MAVEN_OPTS, GradleEnterpriseMavenOptsSetter.mergeMavenOpts(existingMavenOpts, systemProperties));
        String updatedEnvironment = this.environmentVariableAccessor.joinEnvironmentVariables(this.quoteValuesIfNeeded(environment));
        configuration.put(ENVIRONMENT_VARIABLES_KEY, updatedEnvironment);
    }

    private Map<String, String> quoteValuesIfNeeded(Map<String, String> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, EnvironmentVariables::quoteValueIfNeeded));
    }
}

