/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.bamboo;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CurrentResult;
import com.gradle.enterprise.bamboo.BuildScanCollector;
import com.gradle.enterprise.bamboo.BuildScanInjector;
import com.gradle.enterprise.bamboo.BuildScanLogScanner;
import com.gradle.enterprise.bamboo.config.BuildToolConfiguration;
import com.gradle.enterprise.bamboo.config.PersistentConfigurationManager;
import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

abstract class AbstractBuildScanInjector<C extends BuildToolConfiguration>
implements BuildScanInjector<C> {
    private final BuildLoggerManager buildLoggerManager;
    private final PersistentConfigurationManager configurationManager;

    protected AbstractBuildScanInjector(BuildLoggerManager buildLoggerManager, PersistentConfigurationManager configurationManager) {
        this.buildLoggerManager = buildLoggerManager;
        this.configurationManager = configurationManager;
    }

    protected final Optional<C> loadConfiguration() {
        return this.configurationManager.load().map(this::buildToolConfiguration);
    }

    protected final void setupBuildScansLogInterceptor(BuildContext buildContext) {
        BuildLogger buildLogger = this.buildLoggerManager.getLogger((ResultKey)buildContext.getPlanResultKey());
        buildLogger.getInterceptorStack().add((LogInterceptor)new BuildScanLogScanner(new BuildScanCollector(buildContext)));
    }

    protected final void registerGradleEnterpriseResources(BuildContext buildContext, File ... resources) {
        CurrentResult currentResult = buildContext.getCurrentResult();
        if (currentResult != null) {
            Arrays.stream(resources).map(File::getAbsolutePath).forEach(resource -> currentResult.getCustomBuildData().merge("gradleEnterprise.resources", resource, this::concat));
        }
    }

    private String concat(String existingResources, String resource) {
        return String.join((CharSequence)",", existingResources, resource);
    }

    protected static boolean anyMatch(Set<Predicate<String>> predicates, RuntimeTaskDefinition task) {
        String pluginKey = task.getPluginKey();
        return predicates.stream().anyMatch(predicate -> predicate.test(pluginKey));
    }
}

