(function($, BAMBOO) {
    'use strict';

    BAMBOO.ArtifactDownloaderConfiguration = (function() {
        var defaults = {
            planSelector: null,
            planKey: null,
            addArtifactSelector: null,
            removeArtifactSelector: null,
            artifactListSelector: null,
            templates: {
                artifactListItem: null
            },
            i18n: {
                allArtifacts: null,
                individualArtifacts: null
            }
        };
        var options;
        var $list;
        var addArtifactListItem = function() {
            var nextTransferId = +$list.data('nextTransferId') + 1;
            $list.data('nextTransferId', nextTransferId);
            $(AJS.template.load(options.templates.artifactListItem).fill({ index: nextTransferId }).toString())
                .appendTo($list)
                .find(options.selectedArtifactSelector).end()
                .slideDown();
            loadAndPopulateArtifacts(nextTransferId)
                .done(function() { BAMBOO.DynamicFieldParameters.syncFieldShowHide($list); });
            if (nextTransferId === 0) {
                var newItem = $('[data-artifact-id="0"]', $list);
                $(options.removeArtifactSelector, newItem).remove();
            }
        };
        var reloadArtifactsForPlanOnChange = function(instance, model) {
            /*
             * In widget/autocomplete-controls/bamboo/plan-single-select.js 'plan:selected'
             * event is fired with two possible payloads: model when plan is selected from the
              * list or input field content. This handler should process only when user selected plan
              * from the dropdown
             */
            if (model instanceof Backbone.Model) {
                var newPlanKey = model.get('key');
                if (options.planKey === newPlanKey) {
                    return;
                }

                options.planKey = newPlanKey;
                removeArtifactListItems();
                addArtifactListItem();
                if (options.planKey !== '') {
                    $(options.addArtifactSelector).show();
                }
            }
        };
        var loadAndPopulateArtifacts = function(reloadIndex) {
            var $li;
            $(options.artifactListSelector).find('li').each(function() {
                var index = $(this).attr('data-artifact-id');
                if (+index === reloadIndex) {
                    $li = $(this);
                    return false;
                }
            });
            $li.find('input').val('');
            var $select = $li.find('select');
            $select.find('optgroup').remove();

            return loadArtifacts().then(function(artifacts) {
                addArtifactsToSelect($select, artifacts);
            });
        };
        var loadArtifacts = function() {
            var promise = $.Deferred();
            loadPagedArtifacts().then(function(response) {
                var size = response.artifacts.size;
                var maxResults = response.artifacts['max-result'];
                if (size > maxResults) {
                    var pagesToFetch = [];
                    for (var i = 1; i < Math.ceil(size / maxResults); i++) {
                        pagesToFetch.push(loadPagedArtifacts(i * maxResults, maxResults));
                    }
                    $.when.apply($, pagesToFetch).done(function() {
                        var artifacts = response.artifacts.artifact;
                        (pagesToFetch.length === 1 ? [arguments] : _.toArray(arguments)).forEach(function(arg) {
                            artifacts = artifacts.concat(arg[0].artifacts.artifact);
                        });
                        promise.resolve(artifacts);
                    });
                } else {
                    promise.resolve(response.artifacts.artifact);
                }
            }).fail(function(xhr, textStatus, errorThrown) {
                console.log('couldn\'t retrieve artifacts: ' + textStatus); // eslint-disable-line
            });
            return promise;
        };
        var loadPagedArtifacts = function(startIndex, maxResults) {
            return $.ajax({
                url: AJS.contextPath() + '/rest/api/latest/plan/' + options.planKey + '/artifact',
                dataType: 'json',
                data: _.extend({
                    'start-index': startIndex || 0
                }, maxResults ? {
                    'max-results': maxResults
                } : {})
            });
        };
        var addArtifactsToSelect = function(select, artifacts) {
            var optgroup = $('<optgroup/>').attr('label', options.i18n.individualArtifacts);
            for (var i = 0, ii = artifacts.length; i < ii; i++) {
                var artifact = artifacts[i];
                var option = $('<option/>').attr('value', artifact.id)
                    .text(artifact.name);
                optgroup.append(option);
            }
            select.append(optgroup);
        };
        var removeArtifactListItem = function(e) {
            e.preventDefault();
            $(this).closest('li').slideUp(function() { $(this).remove(); });
        };
        var removeArtifactListItems = function() {
            $(options.artifactListSelector).find('li').remove();
        };
        return {
            init: function(opts) {
                options = $.extend(true, defaults, opts);
                $(function() {
                    options.planKey = $(options.planSelector).val();
                    $list = $(options.artifactListSelector)
                        .on('click', options.removeArtifactSelector, removeArtifactListItem);

                    require('util/events').EventBus.on('plan:selected', reloadArtifactsForPlanOnChange);
                    $(options.addArtifactSelector).click(addArtifactListItem);

                    if (options.planKey === '') {
                        $(options.addArtifactSelector).hide();
                    }
                });
            }
        };
    }());
}(jQuery, window.BAMBOO = (window.BAMBOO || {})));
