### Control services and wait for completion

Set-ExecutionPolicy Bypass
$ErrorActionPreference = "Stop"

function waitToComplete {
  param([string]$computerName, [string]$service, [string]$status, [int32]$timeout)
  
  Write-Output "Waiting for service $service on server $computerName to go to $status status..."
  
  $timeSpan = New-TimeSpan -Seconds $timeout
  $remoteService = Get-Service -ComputerName $computerName -Name $service 
  $remoteService.WaitForStatus($status, $timeSpan)
}

function waitForResponse {
    param([string]$url, [int32]$timeout)

    Write-Output "Waiting for service to respond on URL $url..."

    $startDate = Get-Date

    # call URL until it returns a 200 status
    do {
        $Response = $null
        $Response = try { Invoke-WebRequest -Uri $url -UseBasicParsing } catch { $_ }
        if ($Response.StatusCode) {
            $StatusCode = $Response.StatusCode
        }
        else {
            $StatusCode = $Response
        }
        Write-Output "  Status Code = $StatusCode"
        if ($startDate.AddSeconds($timeout) -lt (Get-Date)) {
            Throw "Service took too long to respond. Exiting with timeout error..."
        }
        if (!$StatusCode.Equals(200)) {
            Start-Sleep -seconds 2
        }
    } while (!$StatusCode.Equals(200))
}

function controlService {
  param([string]$computerName = "localhost", [string]$service, [string]$command)

  Write-Output "Going to send $command command to service $service on server $computerName"

  #check current status 
  $remoteService = Get-Service -ComputerName $computerName -Name $service 
  $status = $remoteService."Status"
  Write-Output "  Current status: $status"
  
  # Restart Service will restart or when already stopped, just start it
  if ($command -eq "Restart") {
      Restart-Service -InputObject $remoteService
      Write-Output "  Service stopped and start request sent"
  }
  elseif ($command -eq "Start") {
      Start-Service -InputObject $remoteService
      Write-Output "  Start request sent to service"
  } 
  elseif ($command -eq "Stop") {
      Stop-Service -InputObject $remoteService -NoWait
      Write-Output "  Stop request sent to service"
  }

}

function waitExtra {
    param([int32]$seconds)
    Write-Output "Waiting for an additional $seconds seconds..."
    Start-Sleep -seconds $seconds
}
