<div id="github-repository-edit">
[#assign usernameDescription]
    [@s.text name='repository.github.username.description']
        [@s.param][@help.href pageKey='github.help'/][/@s.param]
    [/@s.text]
[/#assign]
[@s.textfield labelKey='repository.github.username' name='repository.github.username' required=true description=usernameDescription/]
[#assign patDescription]
    [@s.text name='repository.github.password.description']
        [@s.param][@help.href pageKey='github.help'/][/@s.param]
    [/@s.text]
[/#assign]
[#if stack.findValue('repository.github.password')?has_content]
    [@s.checkbox labelKey='repository.github.password.change' toggle=true name='temporary.github.password.change' /]
    [@ui.bambooSection dependsOn='temporary.github.password.change']
        [@s.password labelKey='repository.github.password' name='repository.github.temporary.password' description=patDescription/]
    [/@ui.bambooSection]
[#else]
    [@s.hidden name='temporary.github.password.change' value='true' /]
    [@s.password labelKey='repository.github.password' name='repository.github.temporary.password' description=patDescription/]
[/#if]

[@s.checkbox labelKey='repository.github.enterprise' toggle=true name='repository.github.enterprise' /]
[@ui.bambooSection dependsOn='repository.github.enterprise']
    [@s.textfield labelKey='repository.github.baseUrl' name='repository.github.baseUrl' descriptionKey='repository.github.baseUrl.description' /]
[/@ui.bambooSection]

[@s.select labelKey='repository.github.repository' name='repository.github.repository' descriptionKey='repository.github.repository.description' fieldClass='github-repository'
    cssClass='select2-container aui-select2-container']
    [@s.param name='disabled' value=!(stack.findValue('repository.github.repository')?has_content) /]
    [@s.param name='extraUtility'][@ui.displayButton id='repository-github-load-repositories' valueKey='repository.github.loadRepositories'/][/@s.param]
    [#if stack.findValue('repository.github.repository')?has_content]
        [@s.param name='headerKey2' value=stack.findValue('repository.github.repository') /]
        [@s.param name='headerValue2' value=stack.findValue('repository.github.repository') /]
    [/#if]
[/@s.select]
</div>

<script type="text/javascript">
    if (typeof require !== 'undefined') {
        try {
        require([ 'feature/github-repository-form' ], function(RepositoryForm) {
            var rf = new RepositoryForm({
                repositoryKey: 'com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:gh2',
                repositoryId: ${(repositoryId)!0},
                selectors: {
                    repositoryType: '#selectedRepository',
                    repositoryPluginKey: '#repositoryPluginKey',
                    container: '#github-repository-edit',
                    username: 'input[name="repository.github.username"]',
                    password: 'input[name="repository.github.temporary.password"]',
                    baseUrl: 'input[name="repository.github.baseUrl"]',
                    loadRepositoriesButton: '#repository-github-load-repositories',
                    repository: 'select[name="repository.github.repository"]',
                    branch: 'select[name="repository.github.branch"]',
                    enterprise: 'input[name="repository.github.enterprise"]'
                }
            [#if inheritedVcsDefinition??]
                ,
                inheritedData: {
                    repository: '${inheritedVcsDefinition.vcsLocation.configuration.get("repository.github.repository")}',
                    id: '${inheritedVcsDefinition.id}'
                }
            [/#if]
            });
            rf.init();
        });
        } catch (e) {
            console.info(e);
        }
    }
</script>
