[#assign planPickerId = "sourcePlanKey" /]

[#-- helper variables for handling deployments without plans --]
[#assign hasArtifactEntries = keys!?has_content /]
[#assign deploymentWithoutPlan = deploymentMode && !hasArtifactEntries /]

[#if deploymentMode]
    [@s.hidden name="sourcePlanKey" value=sourcePlanKey /]
[#else]
    [@s.textfield
        labelKey="artifact.downloader.plan.key"
        name="sourcePlanKey"
        id=planPickerId
        required=true
        template="planPicker"
        placeholderKey="artifact.downloader.plan.placeholder"
        cssClass="long-field" /]
[/#if]

[#macro removeButton]
    <a class="delete-artifact" title="Delete artifact" href="#">
        <span class="assistive">Delete artifact</span>
    </a>
[/#macro]

[#macro artifactSnippet index=0]
    [@s.select
        labelKey="artifact.downloader.name"
        name="artifactId_${index}"
        list="artifacts_${index}"
        required=true
        listKey="id"
        listValue="name"
        groupBy="group" /]
    [@s.textfield labelKey="artifact.downloader.local.path" name="localPath_${index}" required=false cssClass="long-field"/]
    [#if index!=0]
        [@removeButton /]
    [/#if]
[/#macro]

[#if deploymentWithoutPlan]
    [@ui.messageBox type="error" titleKey="artifact.downloader.deployment.error.no.plan"]
        [@s.text name="artifact.downloader.deployment.error.no.plan.description" /]
    [/@ui.messageBox]
[/#if]

<ul id="artifact-list" data-next-transfer-id="${(nextTransferId??)?then(nextTransferId, 0)}" [#if deploymentWithoutPlan]class="hidden"[/#if]>
[#if keys??]
[#list keys as index]
    <li data-artifact-id="${index}">[@artifactSnippet index/]</li>
[/#list]
[/#if]
</ul>

[#if !deploymentWithoutPlan]
    <a id="artifact-add">[@ww.text name="artifact.download.task.add"/]</a>
[/#if]

<script type="text/x-template" title="artifact-list-item-template">
    [#assign artifactSnippetInst][@artifactSnippet 869576137068 /][/#assign]
    <li data-artifact-id="{index}" data-added='true'>${artifactSnippetInst?replace("869576137068", "{index}")}</li>
</script>

<script type="text/javascript">
    BAMBOO.ArtifactDownloaderConfiguration.init({
                                                    planSelector: "#${planPickerId}",
                                                    addArtifactSelector: "#artifact-add",
                                                    artifactListSelector: "#artifact-list",
                                                    removeArtifactSelector: 'a.delete-artifact',
                                                    templates: {
                                                        artifactListItem: "artifact-list-item-template"
                                                    },
                                                    i18n: {
                                                        allArtifacts: "${action.getText("artifact.downloader.all.artifacts")}",
                                                        individualArtifacts: "${action.getText("artifact.downloader.individual.artifacts")}"
                                                    }
                                                });
</script>
