/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.BitmapIndexImpl;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexBuilder;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexRemapper;
import org.eclipse.jgit.internal.storage.pack.PackWriterBitmapWalker;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.BlockList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PackWriterBitmapPreparer {
    private static final Comparator<BitmapIndex.BitmapBuilder> BUILDER_BY_CARDINALITY_DSC = new Comparator<BitmapIndex.BitmapBuilder>(){

        @Override
        public int compare(BitmapIndex.BitmapBuilder a, BitmapIndex.BitmapBuilder b) {
            return Integer.signum(b.cardinality() - a.cardinality());
        }
    };
    private final ObjectReader reader;
    private final ProgressMonitor pm;
    private final Set<? extends ObjectId> want;
    private final PackBitmapIndexBuilder writeBitmaps;
    private final BitmapIndexImpl commitBitmapIndex;
    private final PackBitmapIndexRemapper bitmapRemapper;
    private final BitmapIndexImpl bitmapIndex;
    private final int minCommits = 100;
    private final int maxCommits = 5000;

    PackWriterBitmapPreparer(ObjectReader reader, PackBitmapIndexBuilder writeBitmaps, ProgressMonitor pm, Set<? extends ObjectId> want) throws IOException {
        this.reader = reader;
        this.writeBitmaps = writeBitmaps;
        this.pm = pm;
        this.want = want;
        this.commitBitmapIndex = new BitmapIndexImpl(writeBitmaps);
        this.bitmapRemapper = PackBitmapIndexRemapper.newPackBitmapIndex(reader.getBitmapIndex(), writeBitmaps);
        this.bitmapIndex = new BitmapIndexImpl(this.bitmapRemapper);
    }

    Collection<BitmapCommit> doCommitSelection(int expectedNumCommits) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.pm.beginTask(JGitText.get().selectingCommits, 0);
        RevWalk rw = new RevWalk(this.reader);
        WalkResult result = this.findPaths(rw, expectedNumCommits);
        this.pm.endTask();
        int totCommits = result.commitsByOldest.length - result.commitStartPos;
        BlockList<BitmapCommit> selections = new BlockList<BitmapCommit>(totCommits / 100 + 1);
        for (BitmapCommit reuse : result.reuse) {
            selections.add(reuse);
        }
        if (totCommits == 0) {
            for (AnyObjectId id : result.peeledWant) {
                selections.add(new BitmapCommit(id, false, 0));
            }
            return selections;
        }
        this.pm.beginTask(JGitText.get().selectingCommits, totCommits);
        for (BitmapIndex.BitmapBuilder bitmapableCommits : result.paths) {
            int cardinality = bitmapableCommits.cardinality();
            ArrayList running = new ArrayList();
            int index = -1;
            int nextIn = this.nextSelectionDistance(0, cardinality);
            int nextFlg = nextIn == 5000 ? 1 : 0;
            boolean mustPick = nextIn == 0;
            for (RevCommit revCommit : result) {
                List<BitmapCommit> match;
                Object objectId22;
                if (!bitmapableCommits.contains(revCommit)) continue;
                ++index;
                --nextIn;
                this.pm.update(1);
                if (result.peeledWant.remove(revCommit)) {
                    if (nextIn > 0) {
                        nextFlg = 0;
                    }
                } else if (!mustPick && (nextIn > 0 || revCommit.getParentCount() <= 1 && nextIn > -100)) continue;
                int flags = nextFlg;
                nextIn = this.nextSelectionDistance(index, cardinality);
                nextFlg = nextIn == 5000 ? 1 : 0;
                mustPick = nextIn == 0;
                BitmapIndexImpl.CompressedBitmapBuilder fullBitmap = this.commitBitmapIndex.newBitmapBuilder();
                rw.reset();
                rw.markStart(revCommit);
                for (Object objectId22 : result.reuse) {
                    rw.markUninteresting(rw.parseCommit((AnyObjectId)objectId22));
                }
                rw.setRevFilter(PackWriterBitmapWalker.newRevFilter(null, fullBitmap));
                while (rw.next() != null) {
                }
                ArrayList<List> matches = new ArrayList<List>();
                objectId22 = running.iterator();
                while (objectId22.hasNext()) {
                    List list = (List)objectId22.next();
                    BitmapCommit last = (BitmapCommit)list.get(list.size() - 1);
                    if (!fullBitmap.contains(last)) continue;
                    matches.add(list);
                }
                if (matches.isEmpty()) {
                    match = new ArrayList();
                    running.add(match);
                } else {
                    match = (List)matches.get(0);
                    for (List list : matches) {
                        if (list.size() <= match.size()) continue;
                        match = list;
                    }
                }
                match.add(new BitmapCommit(revCommit, !match.isEmpty(), flags));
                this.writeBitmaps.addBitmap((AnyObjectId)revCommit, fullBitmap, 0);
            }
            for (List list : running) {
                selections.addAll(list);
            }
        }
        this.writeBitmaps.clearBitmaps();
        for (AnyObjectId remainingWant : result.peeledWant) {
            selections.add(new BitmapCommit(remainingWant, false, 0));
        }
        this.pm.endTask();
        return selections;
    }

    /*
     * WARNING - void declaration
     */
    private WalkResult findPaths(RevWalk rw, int expectedNumCommits) throws MissingObjectException, IOException {
        void var8_12;
        RevCommit rc;
        BitmapIndexImpl.CompressedBitmapBuilder reuseBitmap = this.commitBitmapIndex.newBitmapBuilder();
        ArrayList<BitmapCommit> reuse = new ArrayList<BitmapCommit>();
        for (PackBitmapIndexRemapper.Entry entry : this.bitmapRemapper) {
            Object ro;
            if ((entry.getFlags() & 1) != 1 || !((ro = rw.peel(rw.parseAny(entry))) instanceof RevCommit)) continue;
            RevCommit revCommit = (RevCommit)ro;
            reuse.add(new BitmapCommit(revCommit, false, entry.getFlags()));
            rw.markUninteresting(revCommit);
            EWAHCompressedBitmap bitmap = this.bitmapRemapper.ofObjectType(this.bitmapRemapper.getBitmap(revCommit), 1);
            this.writeBitmaps.addBitmap((AnyObjectId)revCommit, bitmap, 0);
            reuseBitmap.add(revCommit, 1);
        }
        this.writeBitmaps.clearBitmaps();
        ArrayList<BitmapIndex.BitmapBuilder> paths = new ArrayList<BitmapIndex.BitmapBuilder>(this.want.size());
        HashSet<Object> peeledWant = new HashSet<Object>(this.want.size());
        for (AnyObjectId anyObjectId : this.want) {
            RevObject ro = rw.peel(rw.parseAny(anyObjectId));
            if (!(ro instanceof RevCommit) || reuseBitmap.contains(ro)) continue;
            RevCommit rc3 = (RevCommit)ro;
            peeledWant.add(rc3);
            rw.markStart(rc3);
            BitmapIndex.BitmapBuilder bitmap = this.commitBitmapIndex.newBitmapBuilder();
            bitmap.or(reuseBitmap);
            bitmap.add(rc3, 1);
            paths.add(bitmap);
        }
        RevCommit[] commits = new RevCommit[expectedNumCommits];
        int n = commits.length;
        while ((rc = rw.next()) != null) {
            commits[--var8_12] = rc;
            for (BitmapIndex.BitmapBuilder path : paths) {
                if (!path.contains(rc)) continue;
                for (RevCommit c : rc.getParents()) {
                    path.add(c, 1);
                }
            }
            this.pm.update(1);
        }
        if (!reuse.isEmpty()) {
            for (BitmapIndex.BitmapBuilder bitmap : paths) {
                bitmap.andNot(reuseBitmap);
            }
        }
        ArrayList<BitmapIndex.BitmapBuilder> distinctPaths = new ArrayList<BitmapIndex.BitmapBuilder>(paths.size());
        while (!paths.isEmpty()) {
            Collections.sort(paths, BUILDER_BY_CARDINALITY_DSC);
            BitmapIndex.BitmapBuilder largest = (BitmapIndex.BitmapBuilder)paths.remove(0);
            distinctPaths.add(largest);
            for (int i = paths.size() - 1; i >= 0; --i) {
                ((BitmapIndex.BitmapBuilder)paths.get(i)).andNot(largest);
            }
        }
        return new WalkResult(peeledWant, commits, (int)var8_12, distinctPaths, reuse);
    }

    private int nextSelectionDistance(int idx, int cardinality) {
        if (idx > cardinality) {
            throw new IllegalArgumentException();
        }
        int idxFromStart = cardinality - idx;
        int mustRegionEnd = 100;
        if (idxFromStart <= mustRegionEnd) {
            return 0;
        }
        int minRegionEnd = 20000;
        if (idxFromStart <= minRegionEnd) {
            return Math.min(idxFromStart - mustRegionEnd, 100);
        }
        int next = Math.min(idxFromStart - minRegionEnd, 5000);
        return Math.max(next, 100);
    }

    PackWriterBitmapWalker newBitmapWalker() {
        return new PackWriterBitmapWalker(new ObjectWalk(this.reader), this.bitmapIndex, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WalkResult
    implements Iterable<RevCommit> {
        private final Set<? extends ObjectId> peeledWant;
        private final RevCommit[] commitsByOldest;
        private final int commitStartPos;
        private final List<BitmapIndex.BitmapBuilder> paths;
        private final Iterable<BitmapCommit> reuse;

        private WalkResult(Set<? extends ObjectId> peeledWant, RevCommit[] commitsByOldest, int commitStartPos, List<BitmapIndex.BitmapBuilder> paths, Iterable<BitmapCommit> reuse) {
            this.peeledWant = peeledWant;
            this.commitsByOldest = commitsByOldest;
            this.commitStartPos = commitStartPos;
            this.paths = paths;
            this.reuse = reuse;
        }

        @Override
        public Iterator<RevCommit> iterator() {
            return new Iterator<RevCommit>(){
                int pos;
                {
                    this.pos = WalkResult.this.commitStartPos;
                }

                @Override
                public boolean hasNext() {
                    return this.pos < WalkResult.this.commitsByOldest.length;
                }

                @Override
                public RevCommit next() {
                    return WalkResult.this.commitsByOldest[this.pos++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    static final class BitmapCommit
    extends ObjectId {
        private final boolean reuseWalker;
        private final int flags;

        private BitmapCommit(AnyObjectId objectId, boolean reuseWalker, int flags) {
            super(objectId);
            this.reuseWalker = reuseWalker;
            this.flags = flags;
        }

        boolean isReuseWalker() {
            return this.reuseWalker;
        }

        int getFlags() {
            return this.flags;
        }
    }
}

