/*
 * Decompiled with CFR 0.152.
 */
package com.fouroaksconsulting.tools.jdabambooplugin.task.util;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNLogEntry;

public class SvnLogExtractor
implements ISVNLogEntryHandler {
    private final List<SVNLogEntry> commits;
    private final int commitLimit;
    private long highestRevisionFound = 0L;
    private int skippedCommitsCnt;

    public SvnLogExtractor(@NotNull List<SVNLogEntry> commits, int commitLimit) {
        this.commits = commits;
        this.commitLimit = commitLimit;
    }

    public void handleLogEntry(SVNLogEntry logEntry) {
        if (logEntry.getRevision() > this.highestRevisionFound) {
            this.highestRevisionFound = logEntry.getRevision();
        }
        if (this.commits.size() >= this.commitLimit) {
            ++this.skippedCommitsCnt;
            return;
        }
        this.commits.add(logEntry);
    }

    public int getSkippedCommitsCnt() {
        return this.skippedCommitsCnt;
    }

    public long getHighestRevisionFound() {
        return this.highestRevisionFound;
    }
}

