/*
 * Decompiled with CFR 0.152.
 */
package com.fouroaksconsulting.tools.jdabambooplugin.task.util;

import com.atlassian.bamboo.task.TaskContext;
import com.fouroaksconsulting.tools.jdabambooplugin.task.util.RolloutFile;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class RolloutScript {
    public static void create(TaskContext taskContext, List<RolloutFile> rolloutFileList, String rolloutName, String workingDirectory) {
        ArrayList<CallSite> copyfiles = new ArrayList<CallSite>();
        ArrayList<CallSite> loadfiles = new ArrayList<CallSite>();
        ArrayList<CallSite> msqlfiles = new ArrayList<CallSite>();
        ArrayList<CallSite> sqlfiles = new ArrayList<CallSite>();
        ArrayList<CallSite> integratorfiles = new ArrayList<CallSite>();
        ArrayList<CallSite> ddaexports = new ArrayList<CallSite>();
        ArrayList rebuildmakefiles = new ArrayList();
        ArrayList<CallSite> yamlfiles = new ArrayList<CallSite>();
        Boolean buildmoca = false;
        Boolean buildmtf = false;
        Boolean buildles = false;
        Boolean compileC = false;
        for (RolloutFile rolloutFile : rolloutFileList) {
            String source_folder = "pkg/" + rolloutFile.getDirectoryInLes() + "/";
            String filename = rolloutFile.getFileName();
            Object destination_folder = "$LESDIR/" + rolloutFile.getDirectoryInLes();
            if (((String)destination_folder).endsWith("/")) {
                destination_folder = ((String)destination_folder).substring(0, ((String)destination_folder).length() - 1);
            }
            if (rolloutFile.fileAction.equals(RolloutFile.ADDED) || rolloutFile.fileAction.equals(RolloutFile.MODIFIED)) {
                copyfiles.add((CallSite)((Object)("REPLACE " + source_folder + filename + " " + (String)destination_folder)));
            } else if (rolloutFile.fileAction.equals(RolloutFile.DELETED)) {
                copyfiles.add((CallSite)((Object)("REMOVE " + (String)destination_folder + "/" + filename)));
            }
            if (!rolloutFile.fileAction.equals(RolloutFile.DELETED)) {
                if (((String)destination_folder).toLowerCase().contains("/db/data/") && filename.toLowerCase().endsWith(".csv")) {
                    String ctl_file = (String)destination_folder + ".ctl";
                    loadfiles.add((CallSite)((Object)("LOADDATA " + ctl_file + " " + filename)));
                } else if (((String)destination_folder).toLowerCase().contains("/dda_exports/") && filename.toLowerCase().endsWith(".bat")) {
                    String dda_folder = ((String)destination_folder).replace("$LESDIR", "%LESDIR%");
                    ddaexports.add((CallSite)((Object)("RUNSCRIPT (cd $LESDIR/" + rolloutFile.getDirectoryInLes() + " && " + rolloutFile.getFileName() + " && cd $SOURCEDIR)")));
                } else if (((String)destination_folder).toLowerCase().contains("/db/ddl/") && filename.toLowerCase().endsWith(".msql")) {
                    msqlfiles.add((CallSite)((Object)("RUNMSQL " + (String)destination_folder + "/" + filename)));
                } else if (((String)destination_folder).toLowerCase().contains("/db/ddl/") && filename.toLowerCase().endsWith(".sql")) {
                    sqlfiles.add((CallSite)((Object)("RUNSQL " + (String)destination_folder + "/" + filename)));
                } else if (((String)destination_folder).toLowerCase().contains("/db/ddl/") && filename.toLowerCase().endsWith(".tbl")) {
                    sqlfiles.add((CallSite)((Object)("RUNSQL " + (String)destination_folder + "/" + filename)));
                } else if (((String)destination_folder).toLowerCase().contains("/db/ddl/") && filename.toLowerCase().endsWith(".pck")) {
                    sqlfiles.add((CallSite)((Object)("RUNSQL " + (String)destination_folder + "/" + filename)));
                } else if (((String)destination_folder).toLowerCase().contains("/db/ddl/") && filename.toLowerCase().endsWith(".bdy")) {
                    sqlfiles.add((CallSite)((Object)("RUNSQL " + (String)destination_folder + "/" + filename)));
                } else if (((String)destination_folder).toLowerCase().contains("/db/ddl/") && filename.toLowerCase().endsWith(".hdr")) {
                    sqlfiles.add((CallSite)((Object)("RUNSQL " + (String)destination_folder + "/" + filename)));
                } else if (((String)destination_folder).toLowerCase().contains("/db/ddl/") && filename.toLowerCase().endsWith(".prc")) {
                    sqlfiles.add((CallSite)((Object)("RUNSQL " + (String)destination_folder + "/" + filename)));
                } else if (((String)destination_folder).toLowerCase().contains("/db/ddl/") && filename.toLowerCase().endsWith(".trg")) {
                    sqlfiles.add((CallSite)((Object)("RUNSQL " + (String)destination_folder + "/" + filename)));
                } else if (((String)destination_folder).toLowerCase().contains("/db/ddl/") && filename.toLowerCase().endsWith(".seq")) {
                    sqlfiles.add((CallSite)((Object)("RUNSQL " + (String)destination_folder + "/" + filename)));
                } else if (((String)destination_folder).toLowerCase().contains("/integrator") && filename.toLowerCase().endsWith(".slexp")) {
                    integratorfiles.add((CallSite)((Object)("IMPORTSLDATA " + (String)destination_folder + "/" + filename)));
                } else if (((String)destination_folder).toLowerCase().contains("/integrator") && filename.toLowerCase().endsWith(".uslexp")) {
                    integratorfiles.add((CallSite)((Object)("IMPORTSLDATA " + (String)destination_folder + "/" + filename)));
                } else if (((String)destination_folder).toLowerCase().contains("/integrator") && filename.toLowerCase().endsWith(".msql")) {
                    msqlfiles.add((CallSite)((Object)("RUNMSQL " + (String)destination_folder + "/" + filename)));
                } else if (filename.toLowerCase().endsWith(".yaml")) {
                    yamlfiles.add((CallSite)((Object)("LOADYAML " + (String)destination_folder + "/" + filename)));
                }
            }
            if (((String)destination_folder).toLowerCase().contains("/src/libsrc/") && filename.toLowerCase().endsWith(".c")) {
                compileC = true;
                continue;
            }
            if (((String)destination_folder).toLowerCase().contains("/src/libsrc/") && filename.toLowerCase().endsWith(".h") || ((String)destination_folder).toLowerCase().contains("/src/incsrc") && filename.toLowerCase().endsWith(".h")) {
                compileC = true;
                continue;
            }
            if (((String)destination_folder).toLowerCase().contains("/mtfclient/src/java") && filename.toLowerCase().endsWith(".java")) {
                buildmtf = true;
                continue;
            }
            if (((String)destination_folder).toLowerCase().contains("/src/java") && filename.toLowerCase().endsWith(".java")) {
                buildles = true;
                continue;
            }
            if (((String)destination_folder).toLowerCase().contains("/src/cmdsrc") && filename.toLowerCase().endsWith(".mcmd")) {
                buildmoca = true;
                continue;
            }
            if (!((String)destination_folder).toLowerCase().contains("/src/cmdsrc") || !filename.toLowerCase().endsWith(".mtrg")) continue;
            buildmoca = true;
        }
        ArrayList<Object> rolloutscript = new ArrayList<Object>();
        rolloutscript.add("# This script has been built automatically using the Four Oaks Consulting - Bamboo custom rollout build utility.");
        rolloutscript.add("# Rollout Name:  " + rolloutName);
        rolloutscript.add("# Build Date:    " + LocalDateTime.now());
        rolloutscript.add("# Bamboo Build #: " + taskContext.getBuildContext().getPlanResultKey());
        rolloutscript.add("# ");
        rolloutscript.add("# Copy files...");
        rolloutscript.addAll(copyfiles);
        rolloutscript.add("");
        rolloutscript.add("# Run scripts...");
        rolloutscript.addAll(msqlfiles);
        rolloutscript.addAll(sqlfiles);
        rolloutscript.add("");
        if (buildmoca.booleanValue()) {
            rolloutscript.add("# Run mbuild before we load data (ctl files may include new commands)...");
            rolloutscript.add("MBUILD");
        }
        rolloutscript.add("");
        rolloutscript.add("# Load integrator transactions...");
        rolloutscript.addAll(integratorfiles);
        rolloutscript.add("");
        rolloutscript.add("# Load data files...");
        rolloutscript.addAll(loadfiles);
        rolloutscript.add("");
        rolloutscript.add("# Load DDA exports...");
        rolloutscript.addAll(ddaexports);
        rolloutscript.add("");
        rolloutscript.add("# Load YAML files...");
        rolloutscript.addAll(yamlfiles);
        rolloutscript.add("");
        rolloutscript.add("# Rebuild C makefiles...");
        rebuildmakefiles = new ArrayList(new LinkedHashSet(rebuildmakefiles));
        rolloutscript.addAll(rebuildmakefiles);
        rolloutscript.add("");
        rolloutscript.add("# Compile C libraries...");
        if (compileC.booleanValue()) {
            rolloutscript.add("RUNSCRIPT cmd /c \"cd %LESDIR%/src & nmake clean install /f makefile.nt\"");
        }
        rolloutscript.add("# Build java packages...");
        if (buildmtf.booleanValue()) {
            rolloutscript.add("RUNSCRIPT ant -buildfile $LESDIR/build.xml mtf-jar");
        }
        if (buildles.booleanValue()) {
            rolloutscript.add("RUNSCRIPT ant -buildfile $LESDIR/build.xml les-jar");
        }
        File rolloutScriptFile = new File(workingDirectory.concat("\\" + rolloutName));
        try {
            rolloutScriptFile.getParentFile().mkdirs();
            rolloutScriptFile.createNewFile();
            Files.write(rolloutScriptFile.toPath(), rolloutscript, Charset.forName("UTF-8"), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

