/*
 * Decompiled with CFR 0.152.
 */
package com.fouroaksconsulting.tools.jdabambooplugin.task.util;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.utils.process.ExternalProcess;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;

public class RolloutInstallHelper {
    ConfigurationMap configurationMap;
    CapabilityContext capabilityContext;
    BuildLogger buildLogger;
    ProcessService processService;
    CommonTaskContext commonTaskContext;
    File rolloutArtifactDir;
    static final String PERL_PATH = "perl.path";

    public RolloutInstallHelper(ConfigurationMap configurationMap, CapabilityContext capabilityContext, BuildLogger buildLogger, ProcessService processService, CommonTaskContext commonTaskContext, File rolloutArtifactDir) {
        this.configurationMap = configurationMap;
        this.capabilityContext = capabilityContext;
        this.buildLogger = buildLogger;
        this.processService = processService;
        this.commonTaskContext = commonTaskContext;
        this.rolloutArtifactDir = rolloutArtifactDir;
    }

    public boolean installWmRollout() {
        if (this.checkArtifactContentEmpty(this.rolloutArtifactDir, this.buildLogger)) {
            return true;
        }
        Map<String, String> envBatVars = this.extractEnvBat((String)this.configurationMap.get((Object)"envBat"), this.buildLogger);
        if (envBatVars.isEmpty()) {
            return false;
        }
        File workDir = Paths.get(envBatVars.get("LESDIR"), "temp", this.getRolloutName(this.rolloutArtifactDir)).toFile();
        ArrayList<String> commandList = new ArrayList<String>();
        String perlPath = this.capabilityContext.getCapabilityValue(PERL_PATH) == null ? "perl" : this.capabilityContext.getCapabilityValue(PERL_PATH);
        commandList.add(perlPath);
        commandList.add("rollout.pl");
        if (!((String)this.configurationMap.get((Object)"perlOptions")).isEmpty()) {
            String[] optionsArray = ((String)this.configurationMap.get((Object)"perlOptions")).split("\\s+");
            commandList.addAll(Arrays.asList(optionsArray));
        }
        String rolloutName = this.getRolloutName(this.rolloutArtifactDir);
        commandList.add(rolloutName);
        return this.installRollout(workDir, envBatVars, commandList);
    }

    public boolean installRefsRollout() {
        if (this.checkArtifactContentEmpty(this.rolloutArtifactDir, this.buildLogger)) {
            return true;
        }
        String DEPLOY_OPTION_SKIP_REFS_DB = "-skipRefsDb";
        Map<String, String> envBatVars = this.extractEnvBat((String)this.configurationMap.get((Object)"envBat"), this.buildLogger);
        if (envBatVars.isEmpty()) {
            return false;
        }
        String refsDir = envBatVars.get("REFSDIR");
        File workDir = Paths.get(refsDir, "..", "rollouts", this.getRolloutName(this.rolloutArtifactDir)).toFile();
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add("cmd");
        commandList.add("/c");
        commandList.add("deploy.cmd");
        if (((String)this.configurationMap.get((Object)"skipRefsDb")).equalsIgnoreCase(Boolean.TRUE.toString())) {
            commandList.add("-skipRefsDb");
        }
        return this.installRollout(workDir, envBatVars, commandList);
    }

    public boolean installRollout(File workDir, Map<String, String> envBatVars, List<String> commandList) {
        String envPathStr = envBatVars.get("PATH");
        List<Object> envPathList = new ArrayList();
        if (envPathStr != null && !envPathStr.isEmpty()) {
            envPathList = Arrays.asList(envPathStr.split(";"));
            envBatVars.remove("PATH");
        }
        if (!this.removeExistingRolloutDir(workDir, this.buildLogger)) {
            return false;
        }
        if (!this.copyArtifactToWorkingDir(workDir, this.rolloutArtifactDir, this.buildLogger)) {
            return false;
        }
        ExternalProcess processInstall = this.processService.createExternalProcess(this.commonTaskContext, new ExternalProcessBuilder().env(envBatVars).path(envPathList).command(commandList).workingDirectory(workDir));
        processInstall.execute();
        if (processInstall.getHandler() != null && (processInstall.getHandler().getExitCode() == 0 || processInstall.getHandler().getExitCode() == 2)) {
            return true;
        }
        String message = processInstall.getHandler().getException() != null ? processInstall.getHandler().getException().getLocalizedMessage() : String.valueOf(processInstall.getHandler().getExitCode());
        this.buildLogger.addErrorLogEntry(" Script failed with error: " + message);
        return false;
    }

    private boolean checkArtifactContentEmpty(File rolloutArtifactDir, BuildLogger buildLogger) {
        Object[] lastDirSegment = rolloutArtifactDir.list();
        if (ArrayUtils.isEmpty((Object[])lastDirSegment)) {
            buildLogger.addErrorLogEntry("No rollout content found. That's ok, the Build task must not have built anything. Exit this task.");
            return true;
        }
        return false;
    }

    private boolean removeExistingRolloutDir(File workDir, BuildLogger buildLogger) {
        buildLogger.addBuildLogEntry("Deleting existing rollout directory if one exists already.");
        try {
            FileUtils.deleteDirectory((File)workDir);
        }
        catch (IllegalArgumentException e) {
            buildLogger.addBuildLogEntry("No existing rollout directory with same name, continuing installation.");
            return true;
        }
        catch (IOException e) {
            buildLogger.addErrorLogEntry("Error deleting existing rollout " + workDir.toString() + " directory. Exiting build... " + e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    private String getRolloutName(File rolloutArtifactDir) {
        return Arrays.stream(rolloutArtifactDir.list()).findFirst().orElse("");
    }

    private boolean copyArtifactToWorkingDir(File workDir, File rolloutArtifactDir, BuildLogger buildLogger) {
        File workDirParent = workDir.toPath().getParent().toFile();
        buildLogger.addBuildLogEntry("Copying the Rollout Artifact to the working directory. From: " + rolloutArtifactDir.toString() + " to: " + workDirParent.toString());
        try {
            FileUtils.copyDirectory((File)rolloutArtifactDir, (File)workDirParent);
        }
        catch (IOException e) {
            buildLogger.addErrorLogEntry("Error copying rollout. Exiting build... " + e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    private Map<String, String> extractEnvBat(String envBatPath, BuildLogger buildLogger) {
        LinkedHashMap<String, String> envBatVars = new LinkedHashMap<String, String>();
        try (BufferedReader br = new BufferedReader(new FileReader(envBatPath));){
            String line = br.readLine();
            while (line != null && !line.isEmpty()) {
                if (!line.substring(0, 1).equalsIgnoreCase("#") && line.substring(0, 3).equalsIgnoreCase("set")) {
                    String varEqVal = line.replaceFirst("set", "").trim();
                    String varNam = varEqVal.substring(0, varEqVal.indexOf("=")).trim().toUpperCase();
                    String varVal = varEqVal.substring(varEqVal.indexOf("=") + 1).trim();
                    if (varVal.equals("%~dp0")) {
                        varVal = Paths.get(envBatPath, new String[0]).getParent().toString();
                    } else if (varVal.startsWith("%") && varVal.endsWith("%") && (varVal = (String)envBatVars.get(varVal.substring(1, varVal.length() - 1))) == null) {
                        varVal = "";
                    }
                    envBatVars.put(varNam, varVal);
                }
                line = br.readLine();
            }
        }
        catch (FileNotFoundException e) {
            buildLogger.addErrorLogEntry("Unable to find env.bat file " + envBatPath + " Error: " + e.getLocalizedMessage());
        }
        catch (IOException e) {
            buildLogger.addErrorLogEntry(" Env.bat file did not contain valid 'set' statements. Cannot read required info ");
        }
        return envBatVars;
    }
}

