/*
 * Decompiled with CFR 0.152.
 */
package com.fouroaksconsulting.tools.jdabambooplugin.task.util;

import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.task.TaskContext;
import com.fouroaksconsulting.tools.jdabambooplugin.task.util.RolloutFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.text.StrSubstitutor;

public class ReadMeFile {
    private static final String HORIZONTAL_LINE = "================================================================================";
    private static final String INDENT_SPACES = "     ";

    public static void create(List<RolloutFile> rolloutFileList, String rolloutName, String workingDirectory, List<LinkedJiraIssue> linkedJiraIssueList, TaskContext taskContext, Boolean isRefsRollout) throws IOException {
        InputStream inputStreamWin;
        ArrayList<CallSite> jiraIssues = new ArrayList<CallSite>();
        ArrayList<CallSite> affectedFiles = new ArrayList<CallSite>();
        ArrayList<CallSite> removedFiles = new ArrayList<CallSite>();
        if (!linkedJiraIssueList.isEmpty()) {
            for (LinkedJiraIssue linkedJiraIssue : linkedJiraIssueList) {
                jiraIssues.add((CallSite)((Object)(INDENT_SPACES + linkedJiraIssue.getJiraIssueDetails().getIssueKey() + " - " + linkedJiraIssue.getJiraIssueDetails().getSummary())));
            }
        }
        for (RolloutFile rolloutFile : rolloutFileList) {
            if (rolloutFile.getFileAction().equals(RolloutFile.ADDED) || rolloutFile.getFileAction().equals(RolloutFile.MODIFIED)) {
                affectedFiles.add((CallSite)((Object)(INDENT_SPACES + rolloutFile.getDirectoryInLes() + "/" + rolloutFile.getFileName() + " - Rev: " + rolloutFile.getCommitFileRevision())));
                continue;
            }
            if (!rolloutFile.getFileAction().equals(RolloutFile.DELETED)) continue;
            removedFiles.add((CallSite)((Object)(INDENT_SPACES + rolloutFile.getDirectoryInLes() + "/" + rolloutFile.getFileName() + " - Rev: " + rolloutFile.getCommitFileRevision())));
        }
        ArrayList<Object> readme = new ArrayList<Object>();
        readme.add(HORIZONTAL_LINE);
        readme.add("# Rollout Name:        " + rolloutName);
        readme.add("# Build Date:          " + LocalDateTime.now());
        readme.add("# Bamboo Build Number: " + taskContext.getBuildContext().getBuildNumber());
        readme.add(HORIZONTAL_LINE);
        readme.add("");
        if (!jiraIssues.isEmpty()) {
            readme.add("JIRA issues included in this release:");
            readme.addAll(jiraIssues);
            readme.add("");
        }
        readme.add("Affected Files:");
        readme.addAll(affectedFiles);
        readme.add("");
        readme.add("Removed Files:");
        readme.addAll(removedFiles);
        readme.add("");
        readme.add("");
        if (!isRefsRollout.booleanValue()) {
            inputStreamWin = ReadMeFile.class.getClassLoader().getResourceAsStream("files/RolloutInstallationNotesWM.txt");
            String instructionsWindows = IOUtils.toString((InputStream)inputStreamWin);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("rolloutName", rolloutName);
            readme.add(StrSubstitutor.replace((Object)instructionsWindows, data));
            readme.add("");
        } else {
            inputStreamWin = ReadMeFile.class.getClassLoader().getResourceAsStream("files/RolloutInstallationNotesRefs.txt");
            String instructionsRefs = IOUtils.toString((InputStream)inputStreamWin);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("rolloutName", rolloutName);
            readme.add(StrSubstitutor.replace((Object)instructionsRefs, data));
            readme.add("");
        }
        if (isRefsRollout.booleanValue()) {
            readme.add("# Following line is added to make the REFS Deploy application work. It finds the hotfix name by reading the readme file.");
            readme.add("Hot Fix: " + rolloutName);
            readme.add("");
        }
        File readmeFile = Paths.get(workingDirectory, "README.txt").toFile();
        try {
            readmeFile.getParentFile().mkdirs();
            readmeFile.createNewFile();
            Files.write(readmeFile.toPath(), readme, Charset.forName("UTF-8"), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

