/*
 * Decompiled with CFR 0.152.
 */
package com.fouroaksconsulting.tools.jdabambooplugin.task.util;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.AuthorImpl;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.commit.CommitContextImpl;
import com.atlassian.bamboo.commit.CommitFile;
import com.atlassian.bamboo.commit.CommitFileImpl;
import com.atlassian.bamboo.commit.CommitImpl;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.repository.svn.v2.AbstractSvnExecutor;
import com.atlassian.bamboo.repository.svn.v2.SvnRepositoryAccessData;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.BuildRepositoryChangesImpl;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.fouroaksconsulting.tools.jdabambooplugin.task.util.RolloutFile;
import com.fouroaksconsulting.tools.jdabambooplugin.task.util.SvnLogExtractor;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc2.SvnExport;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CustomSvnExecutor
extends AbstractSvnExecutor {
    private static final int MAX_COMMITS_TO_RETURN = 10000;

    public BuildRepositoryChanges getBuildChangesForJiraIssues(@NotNull VcsRepositoryData repositoryData, List<String> jiraIssuesList) {
        ArrayList<CommitImpl> commits = new ArrayList<CommitImpl>();
        try {
            ArrayList<SVNLogEntry> svnLogEntryList = new ArrayList<SVNLogEntry>();
            SvnRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(repositoryData);
            SVNClientManager clientManager = this.getSvnClientManager(substitutedAccessData);
            SVNURL repositorySvnUrl = substitutedAccessData.getUrl();
            SVNLogClient svnLogClient = clientManager.getLogClient();
            SVNRevision endRevision = SVNRevision.HEAD;
            SVNRevision startRevision = SVNRevision.create((long)0L);
            SvnLogExtractor svnLogExtractor = new SvnLogExtractor(svnLogEntryList, 10000);
            boolean stopOnCopy = true;
            boolean discoverChangedPaths = true;
            boolean includeMergedRevisions = true;
            long limit = 10000L;
            String[] revisionProperties = null;
            svnLogClient.doLog(repositorySvnUrl, null, null, startRevision, endRevision, stopOnCopy, discoverChangedPaths, includeMergedRevisions, limit, revisionProperties, (ISVNLogEntryHandler)svnLogExtractor);
            for (SVNLogEntry logEntry : svnLogEntryList) {
                for (String jiraIssueKey : jiraIssuesList) {
                    if (!logEntry.getMessage().contains(jiraIssueKey)) continue;
                    CommitImpl commit = new CommitImpl();
                    commit.setComment(logEntry.getMessage());
                    commit.setAuthor((Author)this.getAuthor(logEntry));
                    commit.setDate(logEntry.getDate());
                    commit.setChangeSetId(String.valueOf(logEntry.getRevision()));
                    commits.add(commit);
                    for (SVNLogEntryPath changedPath : logEntry.getChangedPaths().values()) {
                        CommitFileImpl commitFile = new CommitFileImpl(String.valueOf(logEntry.getRevision()), changedPath.getPath(), String.valueOf(logEntry.getRevision()));
                        commit.addFile((CommitFile)commitFile);
                    }
                    commits.add(commit);
                }
            }
        }
        catch (SVNException e) {
            throw new RuntimeException(e);
        }
        BuildRepositoryChangesImpl buildChanges = new BuildRepositoryChangesImpl(repositoryData.getId(), null, commits, null);
        buildChanges.setSkippedCommitsCount(0);
        return buildChanges;
    }

    private AuthorImpl getAuthor(SVNLogEntry svnLogEntry) {
        if (svnLogEntry.getAuthor() == null || svnLogEntry.getAuthor().isEmpty()) {
            return new AuthorImpl("[unknown]");
        }
        return new AuthorImpl(svnLogEntry.getAuthor());
    }

    public List<RolloutFile> getRolloutFileInfoFromSvnCommits(@NotNull VcsRepositoryData repositoryData, List<CommitContext> commitContextList) throws RepositoryException {
        ArrayList<RolloutFile> arrayList;
        SVNClientManager clientManager = null;
        ArrayList<RolloutFile> rolloutFileList = new ArrayList<RolloutFile>();
        try {
            ArrayList<SVNLogEntry> svnLogEntryList = new ArrayList<SVNLogEntry>();
            SvnRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(repositoryData);
            clientManager = this.getSvnClientManager(substitutedAccessData);
            SVNURL repositorySvnUrl = substitutedAccessData.getUrl();
            SVNLogClient svnLogClient = clientManager.getLogClient();
            ArrayList<SVNRevisionRange> svnRevisionRangeList = new ArrayList<SVNRevisionRange>();
            for (CommitContext commitContext : commitContextList) {
                SVNRevision svnRevision = SVNRevision.create((long)Long.valueOf(commitContext.getChangeSetId()));
                SVNRevisionRange svnRevisionRange = new SVNRevisionRange(svnRevision, svnRevision);
                svnRevisionRangeList.add(svnRevisionRange);
            }
            SvnLogExtractor svnLogExtractor = new SvnLogExtractor(svnLogEntryList, 10000);
            boolean stopOnCopy = true;
            boolean discoverChangedPaths = true;
            boolean includeMergedRevisions = true;
            long limit = 10000L;
            String[] revisionProperties = null;
            svnLogClient.doLog(repositorySvnUrl, null, null, svnRevisionRangeList, stopOnCopy, discoverChangedPaths, includeMergedRevisions, limit, revisionProperties, (ISVNLogEntryHandler)svnLogExtractor);
            for (SVNLogEntry logEntry : svnLogEntryList) {
                String revision = String.valueOf(logEntry.getRevision());
                Map changedPaths = logEntry.getChangedPaths();
                CommitContextImpl commitContext = CommitContextImpl.builder().author(logEntry.getAuthor()).date(logEntry.getDate()).comment(logEntry.getMessage()).changesetId(revision).files((Iterable)changedPaths.entrySet().stream().map(entry -> {
                    String path = (String)entry.getKey();
                    return new CommitFileImpl(revision, path, revision);
                }).collect(Collectors.toList())).build();
                for (SVNLogEntryPath changedPath : logEntry.getChangedPaths().values()) {
                    char fileAction;
                    if (!changedPath.getKind().equals(SVNNodeKind.FILE)) continue;
                    switch (changedPath.getType()) {
                        case 'A': {
                            fileAction = RolloutFile.ADDED.charValue();
                            break;
                        }
                        case 'M': {
                            fileAction = RolloutFile.MODIFIED.charValue();
                            break;
                        }
                        case 'D': {
                            fileAction = RolloutFile.DELETED.charValue();
                            break;
                        }
                        case 'R': {
                            String copyRevision = String.valueOf(logEntry.getRevision());
                            String copyPath = changedPath.getCopyPath();
                            CommitFileImpl commitFileCopy = new CommitFileImpl(copyRevision, copyPath, copyRevision);
                            int branchIndex = copyPath.indexOf(substitutedAccessData.getRepositoryUrl()) + substitutedAccessData.getRepositoryUrl().length();
                            String pathInBranch = copyPath.substring(branchIndex);
                            String lesDirSlash = "LES/";
                            int lesDirIndex = pathInBranch.indexOf(lesDirSlash) < 0 ? 0 : pathInBranch.indexOf(lesDirSlash) + lesDirSlash.length();
                            int fileNameIndex = pathInBranch.indexOf("/" + Paths.get(commitFileCopy.getName().toString(), new String[0]).getFileName().toString());
                            String pathInLES = pathInBranch.substring(lesDirIndex, fileNameIndex);
                            RolloutFile rf = new RolloutFile((CommitContext)commitContext, (CommitFile)commitFileCopy, RolloutFile.DELETED.charValue(), pathInLES);
                            rolloutFileList.add(rf);
                            fileAction = RolloutFile.ADDED.charValue();
                            break;
                        }
                        default: {
                            fileAction = RolloutFile.MODIFIED.charValue();
                        }
                    }
                    String path = changedPath.getPath();
                    CommitFileImpl commitFile = new CommitFileImpl(revision, path, revision);
                    int branchIndex = path.indexOf(substitutedAccessData.getBranchPath()) + substitutedAccessData.getBranchPath().length() + 1;
                    String pathInBranch = path.substring(branchIndex);
                    String lesDirSlash = "LES/";
                    int lesDirIndex = pathInBranch.indexOf(lesDirSlash) < 0 ? 0 : pathInBranch.indexOf(lesDirSlash) + lesDirSlash.length();
                    int fileNameIndex = pathInBranch.indexOf("/" + Paths.get(commitFile.getName().toString(), new String[0]).getFileName().toString());
                    String pathInLES = pathInBranch.substring(lesDirIndex, fileNameIndex);
                    RolloutFile rolloutFile = new RolloutFile((CommitContext)commitContext, (CommitFile)commitFile, fileAction, pathInLES);
                    rolloutFileList.add(rolloutFile);
                }
            }
            arrayList = rolloutFileList;
        }
        catch (SVNException e) {
            try {
                throw new RepositoryException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.svnClientManagerFactory.dispose(clientManager);
                throw throwable;
            }
        }
        this.svnClientManagerFactory.dispose(clientManager);
        return arrayList;
    }

    public void exportFilestoRolout(@NotNull VcsRepositoryData repositoryData, List<RolloutFile> rolloutFileList, File rolloutDirectory, String packageSubDir, String packageRootDir) throws SVNException {
        SvnRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(repositoryData);
        SVNClientManager clientManager = this.getSvnClientManager(substitutedAccessData);
        SVNURL repositorySvnUrl = substitutedAccessData.getUrl();
        SVNWCClient svnwcClient = clientManager.getWCClient();
        SvnExport svnExport = svnwcClient.getOperationsFactory().createExport();
        Path packageRootDirPath = Paths.get(packageRootDir, new String[0]);
        Path packageSubDirPath = Paths.get(packageSubDir, new String[0]);
        for (RolloutFile rolloutFile : rolloutFileList) {
            SVNRevision svnRevision = SVNRevision.create((long)Long.valueOf(rolloutFile.getCommitFile().getRevision()));
            String repoPathNoBranchName = repositorySvnUrl.toString().replaceFirst("/" + substitutedAccessData.getBranchPath(), "");
            String repoPathNoSvnProject = repoPathNoBranchName.substring(0, repoPathNoBranchName.lastIndexOf("/"));
            SVNURL sourceFileUrl = SVNURL.parseURIEncoded((String)(repoPathNoSvnProject + rolloutFile.getCommitFile().getName()));
            SvnTarget svnSourceFile = SvnTarget.fromURL((SVNURL)sourceFileUrl, (SVNRevision)svnRevision);
            String pathInSubDirString = packageRootDirPath.subpath(0, 1).toString().isEmpty() ? rolloutFile.pathInLES : packageRootDirPath.relativize(Paths.get(rolloutFile.pathInLES, new String[0])).toString();
            Path rolloutFilePath = Paths.get(rolloutDirectory.toString(), packageSubDir, pathInSubDirString, rolloutFile.getFileName());
            File dstPath = rolloutFilePath.toFile();
            SvnTarget svnDestFile = SvnTarget.fromFile((File)dstPath);
            svnExport.setSingleTarget(svnDestFile);
            svnExport.setSource(svnSourceFile);
            svnExport.setRevision(svnRevision);
            svnExport.run();
        }
    }
}

