/*
 * Decompiled with CFR 0.152.
 */
package com.fouroaksconsulting.tools.jdabambooplugin.task.util;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.AuthorImpl;
import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.BuildLoggingContext;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.commit.CommitFile;
import com.atlassian.bamboo.commit.CommitFileImpl;
import com.atlassian.bamboo.commit.CommitImpl;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plugins.git.v2.AbstractGitExecutor;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.BuildRepositoryChangesImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.sal.api.message.I18nResolver;
import com.fouroaksconsulting.tools.jdabambooplugin.task.util.RolloutFile;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.MessageRevFilter;
import org.eclipse.jgit.revwalk.filter.OrRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.io.DisabledOutputStream;

public class CustomGitExecutor
extends AbstractGitExecutor {
    private final CapabilityContext capabilityContext;
    private final CredentialsAccessor credentialsAccessor;
    private final VcsRepositoryData vcsRepositoryData;

    public CustomGitExecutor(CapabilityContext capabilityContext, CredentialsAccessor credentialsAccessor, CustomVariableContext customVariableContext, BuildDirectoryManager buildDirectoryManager, I18nResolver i18nResolver, TrustedKeyHelper trustedKeyHelper, SshProxyService sshProxyService, BuildLoggingContext buildLoggingContext, VcsRepositoryData vcsRepositoryData) {
        super(capabilityContext, credentialsAccessor, customVariableContext, buildDirectoryManager, i18nResolver, trustedKeyHelper, sshProxyService, buildLoggingContext);
        this.capabilityContext = capabilityContext;
        this.credentialsAccessor = credentialsAccessor;
        this.vcsRepositoryData = vcsRepositoryData;
    }

    public BuildRepositoryChanges getBuildChangesforJiraIssues(List<String> jiraIssueDetailsList, File checkoutDirectory, BuildLogger buildLogger, long repositoryId, VcsBranch actualBranch) throws IOException, RepositoryException {
        ArrayList<CommitImpl> commits = new ArrayList<CommitImpl>();
        boolean skippedCommits = false;
        Repository localRepository = null;
        RevWalk revWalk = null;
        TreeWalk treeWalk = null;
        RevFilter orRevFilter = null;
        try {
            localRepository = FileRepositoryBuilder.create(new File(checkoutDirectory, ".git"));
            ObjectDirectory objectDirectory = (ObjectDirectory)Narrow.downTo((Object)localRepository.getObjectDatabase(), ObjectDirectory.class);
            revWalk = new RevWalk(localRepository);
            ObjectId branch = null;
            branch = actualBranch != null ? localRepository.resolve(actualBranch.getName()) : localRepository.resolve("refs/heads/master");
            revWalk.markStart(revWalk.parseCommit(branch));
            if (jiraIssueDetailsList.size() > 1) {
                ArrayList<RevFilter> allFilters = new ArrayList<RevFilter>();
                for (String jiraIssueKey : jiraIssueDetailsList) {
                    allFilters.add(MessageRevFilter.create(jiraIssueKey));
                }
                orRevFilter = OrRevFilter.create(allFilters);
                revWalk.setRevFilter(orRevFilter);
            } else if (jiraIssueDetailsList.size() == 1) {
                orRevFilter = MessageRevFilter.create(jiraIssueDetailsList.get(0));
                revWalk.setRevFilter(orRevFilter);
            }
            revWalk.sort(RevSort.REVERSE);
            treeWalk = new TreeWalk(localRepository);
            treeWalk.setRecursive(true);
            for (RevCommit jgitCommit : revWalk) {
                CommitImpl commit = new CommitImpl();
                commit.setComment(jgitCommit.getFullMessage());
                commit.setAuthor((Author)this.getAuthor(jgitCommit));
                commit.setDate(jgitCommit.getCommitterIdent().getWhen());
                commit.setChangeSetId(jgitCommit.getName());
                commits.add(commit);
                if (jgitCommit.getParentCount() >= 2 || objectDirectory.getShallowCommits().contains(jgitCommit.getId())) continue;
                treeWalk.reset();
                if (jgitCommit.getParentCount() > 0) {
                    treeWalk.addTree(jgitCommit.getParent(0).getTree());
                } else {
                    treeWalk.addTree(new EmptyTreeIterator());
                }
                treeWalk.addTree(jgitCommit.getTree());
                for (DiffEntry entry : DiffEntry.scan(treeWalk)) {
                    if (entry.getOldId().equals(entry.getNewId())) continue;
                    commit.addFile((CommitFile)new CommitFileImpl(jgitCommit.getId().getName(), entry.getChangeType() == DiffEntry.ChangeType.DELETE ? entry.getOldPath() : entry.getNewPath(), jgitCommit.getId().getName()));
                }
            }
        }
        catch (IOException e) {
            String message = "Error getting commits from Jira Issues";
            throw new RepositoryException(buildLogger.addErrorLogEntry(message + " " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (treeWalk != null) {
                treeWalk.release();
            }
            if (revWalk != null) {
                revWalk.release();
            }
            if (localRepository != null) {
                localRepository.close();
            }
        }
        String maxChangeSetId = commits.stream().max(Comparator.comparing(CommitContext::getDate)).map(CommitContext::getChangeSetId).toString();
        BuildRepositoryChangesImpl buildChanges = new BuildRepositoryChangesImpl(repositoryId, maxChangeSetId, commits, actualBranch);
        buildChanges.setSkippedCommitsCount(0);
        return buildChanges;
    }

    private AuthorImpl getAuthor(RevCommit commit) {
        PersonIdent gitPerson = commit.getAuthorIdent();
        if (gitPerson == null) {
            return new AuthorImpl("[unknown]");
        }
        return new AuthorImpl(String.format("%s <%s>", gitPerson.getName(), gitPerson.getEmailAddress()), null, gitPerson.getEmailAddress());
    }

    public List<RolloutFile> getRolloutFileInfoFromGitCommits(List<CommitContext> commitContextList, String checkoutDirectory) {
        ArrayList<RolloutFile> rolloutFileList = new ArrayList<RolloutFile>();
        RevWalk revWalk = null;
        if (commitContextList.isEmpty()) {
            return rolloutFileList;
        }
        try {
            Repository localRepository = FileRepositoryBuilder.create(new File(checkoutDirectory, ".git"));
            for (CommitContext commitContext : commitContextList) {
                ObjectId commitChangeSetID = localRepository.resolve(commitContext.getChangeSetId());
                revWalk = new RevWalk(localRepository);
                RevCommit commit = revWalk.parseCommit(commitChangeSetID);
                RevCommit parent = revWalk.parseCommit(commit.getParent(0).getId());
                DiffFormatter df = new DiffFormatter(DisabledOutputStream.INSTANCE);
                df.setRepository(localRepository);
                df.setDiffComparator(RawTextComparator.DEFAULT);
                df.setDetectRenames(true);
                List<DiffEntry> diffs = df.scan(parent.getTree(), commit.getTree());
                for (DiffEntry diff : diffs) {
                    char fileAction = '\u0000';
                    String path = "";
                    switch (diff.getChangeType()) {
                        case ADD: 
                        case COPY: {
                            fileAction = RolloutFile.ADDED.charValue();
                            path = diff.getNewPath();
                            break;
                        }
                        case MODIFY: {
                            fileAction = RolloutFile.MODIFIED.charValue();
                            path = diff.getNewPath();
                            break;
                        }
                        case DELETE: {
                            fileAction = RolloutFile.DELETED.charValue();
                            path = diff.getOldPath();
                            break;
                        }
                        case RENAME: {
                            rolloutFileList.add(this.getRolloutFile(commitContext, diff.getOldPath(), RolloutFile.DELETED.charValue()));
                            fileAction = RolloutFile.ADDED.charValue();
                            path = diff.getNewPath();
                        }
                    }
                    rolloutFileList.add(this.getRolloutFile(commitContext, path, fileAction));
                }
                df.flush();
            }
            assert (revWalk != null);
            revWalk.dispose();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rolloutFileList;
    }

    private RolloutFile getRolloutFile(CommitContext commitContext, String path, char fileAction) {
        CommitFileImpl commitFile = new CommitFileImpl(commitContext.getChangeSetId(), path, commitContext.getChangeSetId());
        String lesDirSlash = "LES/";
        int lesDirIndex = !path.contains(lesDirSlash) ? 0 : path.indexOf(lesDirSlash) + lesDirSlash.length();
        int fileNameIndex = path.indexOf("/" + Paths.get(commitFile.getName(), new String[0]).getFileName().toString());
        String pathInLES = fileNameIndex <= 0 ? "" : path.substring(lesDirIndex, fileNameIndex);
        return new RolloutFile(commitContext, (CommitFile)commitFile, fileAction, pathInLES);
    }

    public void exportFilestoRolout(List<RolloutFile> rolloutFileList, File rolloutDirectory, String repoDirectory, String packageSubDir, String packageRootDir) throws IOException {
        Repository localRepository = FileRepositoryBuilder.create(new File(repoDirectory, ".git"));
        Path packageRootDirPath = Paths.get(packageRootDir, new String[0]);
        for (RolloutFile rolloutFile : rolloutFileList) {
            ObjectId commitChangeSetID = localRepository.resolve(rolloutFile.getCommitFile().getChangesetId());
            String pathInSubDirString = packageRootDirPath.subpath(0, 1).toString().isEmpty() ? rolloutFile.pathInLES : packageRootDirPath.relativize(Paths.get(rolloutFile.pathInLES, new String[0])).toString();
            Path rolloutFileDestPath = Paths.get(rolloutDirectory.toString(), packageSubDir, pathInSubDirString, rolloutFile.getFileName());
            RevWalk revWalk = new RevWalk(localRepository);
            RevCommit commit = revWalk.parseCommit(commitChangeSetID);
            RevTree tree = commit.getTree();
            String sourcePath = rolloutFile.getCommitFile().getName();
            TreeWalk myTreeWalk = TreeWalk.forPath(localRepository, sourcePath, tree);
            ObjectLoader loader = localRepository.open(myTreeWalk.getObjectId(0));
            if (!rolloutFileDestPath.toFile().getParentFile().exists()) {
                rolloutFileDestPath.toFile().getParentFile().mkdirs();
            }
            OutputStream exportStream = Files.newOutputStream(rolloutFileDestPath.toFile().toPath(), new OpenOption[0]);
            loader.copyTo(exportStream);
            exportStream.close();
            revWalk.dispose();
        }
    }
}

