/*
 * Decompiled with CFR 0.152.
 */
package com.fouroaksconsulting.tools.jdabambooplugin.task.util;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionContext;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.fouroaksconsulting.tools.jdabambooplugin.task.util.AbstractInstallRolloutDeplTask;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractInstallRolloutTask
implements TaskType {
    private ProcessService processService;
    private CapabilityContext capabilityContext;

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }

    public void setCapabilityContext(CapabilityContext capabilityContext) {
        this.capabilityContext = capabilityContext;
    }

    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        BuildLogger buildLogger = taskContext.getBuildLogger();
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        File rolloutArtifactDir = null;
        Collection artifactDefinitionContexts = taskContext.getBuildContext().getArtifactContext().getDefinitionContexts();
        for (ArtifactDefinitionContext artifactDefinitionContext : artifactDefinitionContexts) {
            rolloutArtifactDir = new File(taskContext.getWorkingDirectory(), artifactDefinitionContext.getLocation());
        }
        if (rolloutArtifactDir == null) {
            Collection artifactSubscriptionContexts = taskContext.getBuildContext().getArtifactContext().getSubscriptionContexts();
            for (ArtifactSubscriptionContext artifactSubscriptionContext : artifactSubscriptionContexts) {
                rolloutArtifactDir = new File(artifactSubscriptionContext.getEffectiveDestinationPath());
            }
        }
        if (rolloutArtifactDir == null) {
            rolloutArtifactDir = AbstractInstallRolloutDeplTask.getArtifactDirFromDownloadTask(taskContext.getCommonContext().getRuntimeTaskDefinitions(), taskContext.getWorkingDirectory());
        }
        if (rolloutArtifactDir == null) {
            buildLogger.addErrorLogEntry(" Could not find artifact (Rollout) directory definition. Make sure the Install Rollout Job has an Artifact Dependency defined, or a previous task in the same job downloaded the artifact (e.g. task type 'Download Rollout'. Exiting install.... ");
            return taskResultBuilder.failed().build();
        }
        if (this.installRollout(rolloutArtifactDir, taskContext.getConfigurationMap(), this.capabilityContext, buildLogger, this.processService, (CommonTaskContext)taskContext)) {
            return taskResultBuilder.success().build();
        }
        return taskResultBuilder.failed().build();
    }

    public abstract boolean installRollout(File var1, ConfigurationMap var2, CapabilityContext var3, BuildLogger var4, ProcessService var5, CommonTaskContext var6);
}

