/*
 * Decompiled with CFR 0.152.
 */
package com.fouroaksconsulting.tools.jdabambooplugin.task.util;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.deployments.execution.DeploymentTaskContext;
import com.atlassian.bamboo.deployments.execution.DeploymentTaskType;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractInstallRolloutDeplTask
implements DeploymentTaskType {
    public static final String[] ARTIFACT_DOWNLOADER_PLUGINS = new String[]{"com.atlassian.bamboo.plugins.bamboo-artifact-downloader-plugin:artifactdownloadertask", "com.fouroaksconsulting.tools.jdabambooplugin:rolloutartifactdownloadertask"};
    private ProcessService processService;
    private CapabilityContext capabilityContext;

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }

    public void setCapabilityContext(CapabilityContext capabilityContext) {
        this.capabilityContext = capabilityContext;
    }

    @NotNull
    public TaskResult execute(@NotNull DeploymentTaskContext deploymentTaskContext) throws TaskException {
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)deploymentTaskContext);
        BuildLogger buildLogger = deploymentTaskContext.getBuildLogger();
        File rolloutArtifactDir = AbstractInstallRolloutDeplTask.getArtifactDirFromDownloadTask(deploymentTaskContext.getCommonContext().getRuntimeTaskDefinitions(), deploymentTaskContext.getWorkingDirectory());
        if (rolloutArtifactDir == null) {
            String errorMessage = "Could not find 'Artifact download' task. Make sure the Install Rollout task is preceded by the task Artifact Download or Rollout Download";
            buildLogger.addErrorLogEntry("Could not find 'Artifact download' task. Make sure the Install Rollout task is preceded by the task Artifact Download or Rollout Download");
            return taskResultBuilder.failedWithError().build();
        }
        if (this.installRollout(rolloutArtifactDir, deploymentTaskContext.getConfigurationMap(), this.capabilityContext, buildLogger, this.processService, (CommonTaskContext)deploymentTaskContext)) {
            return taskResultBuilder.success().build();
        }
        return taskResultBuilder.failed().build();
    }

    public abstract boolean installRollout(File var1, ConfigurationMap var2, CapabilityContext var3, BuildLogger var4, ProcessService var5, CommonTaskContext var6);

    public static File getArtifactDirFromDownloadTask(List<RuntimeTaskDefinition> runtimeTaskDefinitionList, File workingDirectory) {
        ArrayList<String> artifactDownloaderPluginList = new ArrayList<String>(Arrays.asList(ARTIFACT_DOWNLOADER_PLUGINS));
        RuntimeTaskDefinition artifactDownloadTaskDef = null;
        for (RuntimeTaskDefinition runtimeTaskDefinition : runtimeTaskDefinitionList) {
            if (!artifactDownloaderPluginList.contains(runtimeTaskDefinition.getPluginKey())) continue;
            artifactDownloadTaskDef = runtimeTaskDefinition;
        }
        if (artifactDownloadTaskDef == null) {
            return null;
        }
        Map.Entry mapEntry = artifactDownloadTaskDef.getConfiguration().entrySet().stream().filter(entry -> ((String)entry.getKey()).contains("localPath")).findFirst().orElse(null);
        String artifactSubDir = mapEntry == null ? null : (String)mapEntry.getValue();
        File rolloutArtifactDir = artifactSubDir == null || artifactSubDir.isEmpty() ? new File(workingDirectory.getPath()) : new File(workingDirectory.getPath(), artifactSubDir);
        return rolloutArtifactDir;
    }
}

