/*
 * Decompiled with CFR 0.152.
 */
package com.fouroaksconsulting.tools.jdabambooplugin.task.util;

import com.atlassian.bamboo.build.JiraIssueResultsManager;
import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.PreparationTask;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskState;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.sal.api.message.I18nResolver;
import com.fouroaksconsulting.tools.jdabambooplugin.preChain.UpdateBuildResultPreChain;
import com.fouroaksconsulting.tools.jdabambooplugin.task.util.CustomGitExecutor;
import com.fouroaksconsulting.tools.jdabambooplugin.task.util.CustomSvnExecutor;
import com.fouroaksconsulting.tools.jdabambooplugin.task.util.RolloutFile;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.tmatesoft.svn.core.SVNException;

public abstract class AbstractBuildRolloutTask
implements CommonTaskType,
PreparationTask {
    public static final String ROLLOUT_NAME_VAR = "rollout.name";
    private VcsRepositoryManager vcsRepositoryManager;
    private RepositoryDefinitionManager repositoryDefinitionManager;
    public ResultsSummaryManager resultsSummaryManager;
    public JiraIssueResultsManager jiraIssueResultsManager;
    private I18nResolver i18nResolver;
    private CustomVariableContext customVariableContext;
    private BuildDirectoryManager buildDirectoryManager;
    private TrustedKeyHelper trustedKeyHelper;
    private SshProxyService sshProxyService;
    private CapabilityContext capabilityContext;
    private CredentialsAccessor credentialsAccessor;

    public void setVcsRepositoryManager(VcsRepositoryManager vcsRepositoryManager) {
        this.vcsRepositoryManager = vcsRepositoryManager;
    }

    public void setRepositoryDefinitionManager(RepositoryDefinitionManager repositoryDefinitionManager) {
        this.repositoryDefinitionManager = repositoryDefinitionManager;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public void setJiraIssueResultsManager(JiraIssueResultsManager jiraIssueResultsManager) {
        this.jiraIssueResultsManager = jiraIssueResultsManager;
    }

    public void setCapabilityContext(CapabilityContext capabilityContext) {
        this.capabilityContext = capabilityContext;
    }

    public void setCredentialsAccessor(CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    public void setBuildDirectoryManager(BuildDirectoryManager buildDirectoryManager) {
        this.buildDirectoryManager = buildDirectoryManager;
    }

    public void setTrustedKeyHelper(TrustedKeyHelper trustedKeyHelper) {
        this.trustedKeyHelper = trustedKeyHelper;
    }

    public void setSshProxyService(SshProxyService sshProxyService) {
        this.sshProxyService = sshProxyService;
    }

    public void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    @NotNull
    public TaskResult execute(@NotNull CommonTaskContext commonTaskContext) throws TaskException {
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)commonTaskContext);
        CommonContext commonContext = commonTaskContext.getCommonContext();
        BuildLogger buildLogger = commonTaskContext.getBuildLogger();
        TaskContext taskContext = (TaskContext)Narrow.downTo((Object)commonTaskContext, TaskContext.class);
        PlanResultKey planResultKey = taskContext.getBuildContext().getPlanResultKey();
        if (!commonContext.getTriggerReason().getKey().equals("com.fouroaksconsulting.tools.jdabambooplugin:jiraReleaseWmsTriggerReason")) {
            buildLogger.addErrorLogEntry("Trigger Reason not equal to com.fouroaksconsulting.tools.jdabambooplugin:jiraReleaseWmsTriggerReason. This task can only run when the build is initiated from Jira when releasing a version. Exiting build... ");
            return taskResultBuilder.failed().build();
        }
        VariableDefinitionContext jiraVersionVar = (VariableDefinitionContext)commonContext.getVariableContext().getEffectiveVariables().get("jira.version");
        if (jiraVersionVar == null) {
            buildLogger.addErrorLogEntry("Jira Release Version not found. Exiting build... ");
            return taskResultBuilder.failed().build();
        }
        String jiraVersion = jiraVersionVar.getValue();
        PlanRepositoryDefinition planRepositoryDefinition = (PlanRepositoryDefinition)taskContext.getBuildContext().getVcsRepositories().get(0);
        VcsRepositoryModuleDescriptor moduleDescriptor = this.getModuleDescriptor(planRepositoryDefinition);
        buildLogger.addBuildLogEntry("Starting rollout generation for repository " + planRepositoryDefinition.getName() + " ....");
        PlanResultKey parentPlanResultKey = taskContext.getBuildContext().getParentBuildContext().getPlanResultKey();
        File checkoutDirectory = UpdateBuildResultPreChain.getRepoWorkingDirectory(this.buildDirectoryManager, parentPlanResultKey, planRepositoryDefinition);
        ArrayList<RolloutFile> rolloutFileList = new ArrayList();
        VcsRepositoryData vcsRepositoryData = this.repositoryDefinitionManager.getVcsRepositoryData(planRepositoryDefinition.getId());
        List commitContextList = taskContext.getBuildContext().getParentBuildContext().getBuildChanges().getChanges();
        String vcsTypeString = moduleDescriptor.getTypeString();
        boolean isGitRepo = vcsTypeString.equalsIgnoreCase("bbCloud") || vcsTypeString.equalsIgnoreCase("bb") || vcsTypeString.equalsIgnoreCase("gh2") || vcsTypeString.equalsIgnoreCase("gitv2");
        boolean isSvnRepo = vcsTypeString.equals("svnv2");
        CustomGitExecutor customGitExecutor = null;
        CustomSvnExecutor customSvnExecutor = null;
        if (isSvnRepo) {
            customSvnExecutor = new CustomSvnExecutor();
        }
        if (isGitRepo) {
            customGitExecutor = new CustomGitExecutor(this.capabilityContext, this.credentialsAccessor, this.customVariableContext, this.buildDirectoryManager, this.i18nResolver, this.trustedKeyHelper, this.sshProxyService, null, vcsRepositoryData);
        }
        if (isSvnRepo) {
            try {
                rolloutFileList = customSvnExecutor.getRolloutFileInfoFromSvnCommits(vcsRepositoryData, commitContextList);
            }
            catch (RepositoryException e) {
                buildLogger.addErrorLogEntry("Error getting files from SVN repository. " + e.getMessage());
            }
        } else if (isGitRepo) {
            rolloutFileList = customGitExecutor.getRolloutFileInfoFromGitCommits(commitContextList, checkoutDirectory.toString());
        } else {
            buildLogger.addErrorLogEntry("Version Control Repository not supported, Only Git and SVN are supported at this point. Submit feature request to get support: https://fouroaksconsulting.atlassian.net/servicedesk/customer/portal/1. Exiting build... ");
            return taskResultBuilder.failed().build();
        }
        if (rolloutFileList.isEmpty()) {
            buildLogger.addErrorLogEntry("Could not find any files to build in this repository (" + planRepositoryDefinition.getName() + ") for the Jira Issues passed in. Failing the build task.");
            return taskResultBuilder.failedWithError().build();
        }
        if (!this.filterRolloutFileListForIncludePaths(taskContext, rolloutFileList, buildLogger)) {
            return taskResultBuilder.failed().build();
        }
        if (rolloutFileList.isEmpty()) {
            buildLogger.addErrorLogEntry("Could not find any files to build in this repository for the Include Paths defined in the Build Rollout task parameters. Exiting task with success.");
            return taskResultBuilder.success().build();
        }
        this.cleanupRolloutFileList(rolloutFileList, buildLogger);
        List<RolloutFile> rolloutFileListToAdd = rolloutFileList.stream().filter(x -> !x.getFileAction().equals(RolloutFile.DELETED)).collect(Collectors.toList());
        buildLogger.addBuildLogEntry("Adding files to Rollout: ");
        if (rolloutFileListToAdd.isEmpty()) {
            buildLogger.addBuildLogEntry("No files to add. That's ok, we must have only deletions in this rollout");
        }
        for (RolloutFile rolloutFile : rolloutFileListToAdd) {
            buildLogger.addBuildLogEntry("- " + rolloutFile.getDirectoryInLes() + "/" + rolloutFile.getFileName() + " - Revision: " + rolloutFile.getCommitFileRevision() + " - Action: " + rolloutFile.getFileAction());
        }
        String rolloutName = this.getRolloutName(jiraVersion, taskContext);
        if (taskContext.getBuildContext().getArtifactContext().getDefinitionContexts().isEmpty()) {
            buildLogger.addErrorLogEntry("Artifact not setup for build plan. Exiting build... ");
            return taskResultBuilder.failed().build();
        }
        for (ArtifactDefinitionContext artifactDefinitionContext : taskContext.getBuildContext().getArtifactContext().getDefinitionContexts()) {
            TaskState state;
            File rolloutDirectory = Paths.get(taskContext.getRootDirectory().toString(), artifactDefinitionContext.getLocation(), rolloutName).toFile();
            if (!rolloutFileListToAdd.isEmpty()) {
                if (isSvnRepo) {
                    try {
                        customSvnExecutor.exportFilestoRolout(vcsRepositoryData, rolloutFileList, rolloutDirectory, this.getPackageSubDir(), this.getPackageRootDir(taskContext));
                    }
                    catch (SVNException e) {
                        buildLogger.addErrorLogEntry("Error exporting files from SVN. " + e.getMessage());
                        return taskResultBuilder.failed().build();
                    }
                } else if (isGitRepo) {
                    try {
                        customGitExecutor.exportFilestoRolout(rolloutFileListToAdd, rolloutDirectory, checkoutDirectory.toString(), this.getPackageSubDir(), this.getPackageRootDir(taskContext));
                    }
                    catch (IOException e) {
                        buildLogger.addErrorLogEntry("Error exporting files from GIT. " + e.getMessage());
                        return taskResultBuilder.failed().build();
                    }
                } else {
                    buildLogger.addErrorLogEntry("Version Control Repository not supported, Only Git and SVN are supported at this point. Exiting build... ");
                    return taskResultBuilder.failed().build();
                }
            }
            if ((state = this.packageRollout(taskContext, rolloutFileList, rolloutFileListToAdd, rolloutName, rolloutDirectory, buildLogger, taskResultBuilder, planResultKey, this.getPackageSubDir(), jiraVersion, checkoutDirectory)) == TaskState.SUCCESS) continue;
            taskResultBuilder.setState(state);
            return taskResultBuilder.build();
        }
        return taskResultBuilder.success().build();
    }

    public abstract String getPackageSubDir();

    public abstract String getPackageRootDir(TaskContext var1);

    public abstract TaskState packageRollout(TaskContext var1, List<RolloutFile> var2, List<RolloutFile> var3, String var4, File var5, BuildLogger var6, TaskResultBuilder var7, PlanResultKey var8, String var9, String var10, File var11);

    public abstract boolean filterRolloutFileListForIncludePaths(TaskContext var1, List<RolloutFile> var2, BuildLogger var3);

    private VcsRepositoryModuleDescriptor getModuleDescriptor(@NotNull PlanRepositoryDefinition planRepositoryDefinition) {
        return (VcsRepositoryModuleDescriptor)Preconditions.checkNotNull((Object)this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(planRepositoryDefinition.getPluginKey()), (Object)("Can't find change detector class for repository plugin " + planRepositoryDefinition.getPluginKey()));
    }

    private void cleanupRolloutFileList(List<RolloutFile> rolloutFileList, BuildLogger buildLogger) {
        ArrayList<String> dbDataSortList = new ArrayList<String>();
        ClassLoader classloader = this.getClass().getClassLoader();
        InputStream inputSteam = classloader.getResourceAsStream("files/DbDataSortList.dat");
        Scanner s = new Scanner(inputSteam);
        while (s.hasNextLine()) {
            dbDataSortList.add(s.nextLine());
        }
        s.close();
        Comparator<RolloutFile> byDate = Comparator.comparing(RolloutFile::getCommitDate);
        Comparator<String> byCsvLoadOrder = Comparator.comparing(dbDataSortList::indexOf);
        Comparator<RolloutFile> byDirectoryInLes = Comparator.comparing(RolloutFile::getDirectoryInLes);
        Comparator<RolloutFile> byDirectory = Comparator.comparing(RolloutFile::getDirectoryInLes, byCsvLoadOrder);
        Comparator<RolloutFile> byLastCommitDate = Comparator.comparing(RolloutFile::getCommitDate);
        ArrayList<RolloutFile> sortedRolloutFileList = new ArrayList<RolloutFile>();
        rolloutFileList.stream().collect(Collectors.groupingBy(RolloutFile::getCommitFileCleanName, Collectors.maxBy(byDate))).values().forEach(f -> f.ifPresent(file -> sortedRolloutFileList.add((RolloutFile)file)));
        sortedRolloutFileList.sort(byDirectory.thenComparing(byDirectoryInLes).thenComparing(byLastCommitDate));
        rolloutFileList.clear();
        rolloutFileList.addAll(sortedRolloutFileList);
    }

    private String getRolloutName(String jiraVersion, TaskContext taskContext) {
        Object rolloutName;
        String rolloutSuffix = (String)taskContext.getConfigurationMap().get((Object)"rolloutSuffix");
        if (jiraVersion != null && !jiraVersion.isEmpty()) {
            rolloutName = jiraVersion.replace(" ", "_").concat(rolloutSuffix == null ? "" : rolloutSuffix);
        } else {
            BuildContext buildContext = taskContext.getBuildContext();
            rolloutName = (String)buildContext.getBuildResult().getCustomBuildData().get("buildKey") + "-" + (String)buildContext.getBuildResult().getCustomBuildData().get("planRepository.branchName") + "-" + (String)buildContext.getBuildResult().getCustomBuildData().get("buildNumber");
            ((String)rolloutName).replace(" ", "_");
        }
        return rolloutName;
    }
}

