/*
 * Decompiled with CFR 0.152.
 */
package com.fouroaksconsulting.tools.jdabambooplugin.task.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.repository.NameValuePair;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskConfiguratorHelper;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowsServiceTaskConfigurator
extends AbstractTaskConfigurator {
    private static final Logger log = Logger.getLogger(WindowsServiceTaskConfigurator.class);
    @Inject
    private TaskConfiguratorHelper taskConfiguratorHelper;
    @Inject
    private I18nResolver i18n;
    private static final String COMMANDLIST = "commands";
    private static final String STATUSLIST = "statuses";
    private static final List<String> WINSERVARGS = Arrays.asList("service.name", "computer.name", "command", "status", "status.timeout", "wait", "response.url", "response.timeout");

    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(config, params, WINSERVARGS);
        return config;
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        if (StringUtils.isEmpty((CharSequence)params.getString("service.name"))) {
            errorCollection.addError("service.name", "windows.service.service.name.missing.error");
        }
        if (StringUtils.isEmpty((CharSequence)params.getString("command"))) {
            errorCollection.addError("command", this.i18n.getText("windows.service.command.missing.error"));
        }
        if (StringUtils.isEmpty((CharSequence)params.getString("status"))) {
            errorCollection.addError("status", this.i18n.getText("windows.service.status.missing.error"));
        }
        if (!params.getString("status").equals(ServiceStatus.NONE.name()) && StringUtils.isEmpty((CharSequence)params.getString("status.timeout"))) {
            errorCollection.addError("status.timeout", this.i18n.getText("windows.service.status.response.missing.error"));
        }
        if (StringUtils.isEmpty((CharSequence)params.getString("response.timeout")) && !StringUtils.isEmpty((CharSequence)params.getString("response.url"))) {
            errorCollection.addError("response.timeout", this.i18n.getText("windows.service.response.timeout.missing.error"));
        }
        if (!StringUtils.isEmpty((CharSequence)params.getString("status.timeout")) && !StringUtils.isNumeric((CharSequence)params.getString("status.timeout"))) {
            errorCollection.addError("status.timeout", this.i18n.getText("windows.service.status.timeout.numeric.error"));
        }
        if (!StringUtils.isEmpty((CharSequence)params.getString("wait")) && !StringUtils.isNumeric((CharSequence)params.getString("wait"))) {
            errorCollection.addError("wait", this.i18n.getText("windows.service.wait.numeric.error"));
        }
        if (!StringUtils.isEmpty((CharSequence)params.getString("response.timeout")) && !StringUtils.isNumeric((CharSequence)params.getString("response.timeout"))) {
            errorCollection.addError("response.timeout", this.i18n.getText("windows.service.response.timeout.numeric.error"));
        }
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, WINSERVARGS);
        context.put(COMMANDLIST, this.getCommands());
        context.put(STATUSLIST, this.getStatuses());
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put(COMMANDLIST, this.getCommands());
        context.put(STATUSLIST, this.getStatuses());
    }

    public List<NameValuePair> getCommands() {
        return Stream.of(Command.NONE, Command.START, Command.STOP, Command.RESTART).map(this::commandToNameValuePair).collect(Collectors.toList());
    }

    private NameValuePair commandToNameValuePair(Command command) {
        return new NameValuePair(command.name(), this.i18n.getText(String.format("win.service.command.%s", command.name()).toLowerCase()), this.i18n.getText(String.format("win.service.command.%s.description", command.name()).toLowerCase()));
    }

    public List<NameValuePair> getStatuses() {
        return Stream.of(ServiceStatus.NONE, ServiceStatus.RUNNING, ServiceStatus.STOPPED, ServiceStatus.PAUSED, ServiceStatus.STARTPENDING, ServiceStatus.STOPPENDING, ServiceStatus.PAUSEPENDING, ServiceStatus.CONTINUEPENDING).map(this::statusToNameValuePair).collect(Collectors.toList());
    }

    private NameValuePair statusToNameValuePair(ServiceStatus status) {
        return new NameValuePair(status.name(), this.i18n.getText(String.format("win.service.status.%s", status.name()).toLowerCase()), this.i18n.getText(String.format("win.service.status.%s.description", status.name()).toLowerCase()));
    }

    public static enum Command {
        NONE,
        START,
        STOP,
        RESTART;

    }

    public static enum ServiceStatus {
        NONE,
        RUNNING,
        STOPPED,
        PAUSED,
        STARTPENDING,
        STOPPENDING,
        CONTINUEPENDING,
        PAUSEPENDING;

    }

    public class WinServArgs {
        public static final String SERVICE_NAME = "service.name";
        public static final String COMPUTER_NAME = "computer.name";
        public static final String COMMAND = "command";
        public static final String STATUS = "status";
        public static final String STATUS_TIMEOUT = "status.timeout";
        public static final String WAIT = "wait";
        public static final String RESPONSE_URL = "response.url";
        public static final String RESPONSE_TIMEOUT = "response.timeout";
    }
}

