/*
 * Decompiled with CFR 0.152.
 */
package com.fouroaksconsulting.tools.jdabambooplugin.task.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.util.TextProviderUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallRolloutUnixTaskConfigurator
extends AbstractTaskConfigurator {
    private static final Logger log = Logger.getLogger(InstallRolloutUnixTaskConfigurator.class);
    private static final List<String> INSTALL_TASK_ARGS = Arrays.asList("dotProfile", "username");

    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        for (String arg : INSTALL_TASK_ARGS) {
            config.put(arg, params.getString(arg));
        }
        return config;
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        String dotProfile = params.getString("dotProfile");
        if (StringUtils.isEmpty((CharSequence)dotProfile)) {
            errorCollection.addError("dotProfile", TextProviderUtils.getTextProvider().getText("install.rollout.dotProfile.error"));
        }
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        for (String arg : INSTALL_TASK_ARGS) {
            context.put(arg, taskDefinition.getConfiguration().get(arg));
        }
    }

    public class InstallRolloutArgs {
        public static final String DOT_PROFILE = "dotProfile";
        public static final String USERNAME = "username";
    }
}

