/*
 * Decompiled with CFR 0.152.
 */
package com.fouroaksconsulting.tools.jdabambooplugin.task;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.utils.process.ExternalProcess;
import com.fouroaksconsulting.tools.jdabambooplugin.task.configuration.WindowsServiceTaskConfigurator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

public class WindowsServiceTask
implements CommonTaskType {
    private ProcessService processService;
    private CapabilityContext capabilityContext;
    public static final String POWERSHELL_PATH = "powershell.path";

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }

    public void setCapabilityContext(CapabilityContext capabilityContext) {
        this.capabilityContext = capabilityContext;
    }

    @NotNull
    public TaskResult execute(@NotNull CommonTaskContext commonTaskContext) throws TaskException {
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)commonTaskContext);
        BuildLogger buildLogger = commonTaskContext.getBuildLogger();
        String serviceName = (String)commonTaskContext.getConfigurationMap().get((Object)"service.name");
        String computerName = (String)commonTaskContext.getConfigurationMap().get((Object)"computer.name");
        String command = (String)commonTaskContext.getConfigurationMap().get((Object)"command");
        String status = (String)commonTaskContext.getConfigurationMap().get((Object)"status");
        String statusTimeout = (String)commonTaskContext.getConfigurationMap().get((Object)"status.timeout");
        String wait = (String)commonTaskContext.getConfigurationMap().get((Object)"wait");
        String responseUrl = (String)commonTaskContext.getConfigurationMap().get((Object)"response.url");
        String responseTimeout = (String)commonTaskContext.getConfigurationMap().get((Object)"response.timeout");
        ArrayList<String> psScript = new ArrayList<String>();
        this.loadScriptFunctions(psScript);
        if (!command.isEmpty() && !command.equals(WindowsServiceTaskConfigurator.Command.NONE.name())) {
            if (computerName.isEmpty()) {
                buildLogger.addBuildLogEntry("Server name not defined, defaulting to localhost");
                computerName = "localhost";
            }
            psScript.add("controlService -service '" + serviceName + "' -computerName '" + computerName + "' -command '" + command + "' \n");
        }
        if (!status.isEmpty() && !status.equals(WindowsServiceTaskConfigurator.ServiceStatus.NONE.name())) {
            psScript.add("waitToComplete -service '" + serviceName + "' -computerName '" + computerName + "' -status '" + status + "' -timeout '" + statusTimeout + "' \n");
        }
        if (!wait.isEmpty()) {
            psScript.add("waitExtra -seconds " + wait + "\n");
        }
        if (!responseUrl.isEmpty()) {
            psScript.add("waitForResponse -url '" + responseUrl + "' -timeout " + responseTimeout + " \n");
        }
        File psScripFile = this.createTemporaryScriptFile(commonTaskContext, psScript);
        String psPath = this.capabilityContext.getCapabilityValue(POWERSHELL_PATH) == null ? "powershell" : this.capabilityContext.getCapabilityValue(POWERSHELL_PATH);
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(psPath);
        cmdList.add("-NonInteractive");
        cmdList.add("-Command");
        cmdList.add(psScripFile.getPath());
        ExternalProcess processPS = this.processService.createExternalProcess(commonTaskContext, new ExternalProcessBuilder().command(cmdList).workingDirectory(commonTaskContext.getWorkingDirectory()));
        processPS.execute();
        psScripFile.delete();
        if (processPS.getHandler().getExitCode() != 0) {
            buildLogger.addErrorLogEntry("Could not run script for windows service. Command returned status: " + processPS.getHandler().getExitCode() + ". Exiting task.");
            return taskResultBuilder.failed().build();
        }
        return taskResultBuilder.success().build();
    }

    private File createTemporaryScriptFile(CommonTaskContext taskContext, List<String> psScriptList) throws TaskException {
        try {
            String prefix = taskContext.getCommonContext().getResultKey().getKey() + "-" + this.getClass().getSimpleName() + "-";
            String psScriptString = String.join((CharSequence)"\n", psScriptList);
            File scriptFile = File.createTempFile(prefix, ".ps1", taskContext.getWorkingDirectory());
            FileUtils.writeStringToFile((File)scriptFile, (String)psScriptString, (String)StandardCharsets.UTF_8.toString());
            scriptFile.deleteOnExit();
            scriptFile.setReadOnly();
            scriptFile.setExecutable(true);
            return scriptFile;
        }
        catch (IOException e) {
            throw new TaskException("Error while creating temporary file for script", (Throwable)e);
        }
    }

    private void loadScriptFunctions(List<String> psScript) {
        ClassLoader classloader = this.getClass().getClassLoader();
        InputStream inputSteam = classloader.getResourceAsStream("files/windows-services-functions.ps1");
        Scanner s = new Scanner(inputSteam);
        while (s.hasNextLine()) {
            psScript.add(s.nextLine());
        }
        s.close();
    }
}

