/*
 * Decompiled with CFR 0.152.
 */
package com.fouroaksconsulting.tools.jdabambooplugin.task;

import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.build.artifact.ArtifactManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.deployments.execution.DeploymentTaskContext;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plugin.ArtifactDownloaderTaskConfigurationHelper;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskState;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.UrlUtils;
import com.atlassian.bamboo.v2.build.BuildContextHelper;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.fouroaksconsulting.tools.jdabambooplugin.task.util.AvailableArtifacts;
import com.fouroaksconsulting.tools.jdabambooplugin.task.util.RequestedArtifacts;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RolloutArtifactDownloaderTask
implements CommonTaskType {
    static final String RESULT_KEY = "resultKey";
    static final String ARTIFACT_LOCATION = "artifactLocation";
    static final String SECURITY_TOKEN = "securityToken";
    static final long ALL_ARTIFACTS_ID = -1L;
    @ComponentImport
    private final ArtifactManager artifactManager;

    public RolloutArtifactDownloaderTask(ArtifactManager artifactManager) {
        this.artifactManager = artifactManager;
    }

    @NotNull
    public TaskResult execute(@NotNull CommonTaskContext taskContext) throws TaskException {
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        BuildLogger buildLogger = taskContext.getBuildLogger();
        ConfigurationMap config = taskContext.getConfigurationMap();
        boolean failOnMissing = false;
        Map runtimeTaskContext = taskContext.getRuntimeTaskContext();
        if (runtimeTaskContext == null) {
            String errorMessage = "Unable to download artifacts: missing runtime context";
            buildLogger.addErrorLogEntry("Unable to download artifacts: missing runtime context");
            return taskResultBuilder.failedWithError().build();
        }
        String resultKey = (String)runtimeTaskContext.get(RESULT_KEY);
        if (StringUtils.isBlank((CharSequence)resultKey)) {
            String errorMessage = "Unable to download artifacts: result key of the last successful build is [" + resultKey + "]";
            buildLogger.addErrorLogEntry(errorMessage);
            return taskResultBuilder.failedWithError().build();
        }
        PlanResultKey planResultKey = PlanKeys.getPlanResultKey((String)resultKey);
        String securityToken = (String)runtimeTaskContext.get(SECURITY_TOKEN);
        LinkedHashSet configArtifactKeys = Sets.newLinkedHashSet((Iterable)ArtifactDownloaderTaskConfigurationHelper.getArtifactKeys((Map)config));
        RequestedArtifacts requestedArtifactContexts = (RequestedArtifacts)taskContext.getRuntimeTaskData().get("artifactContexts");
        for (String artifactKey : configArtifactKeys) {
            int keyIndex;
            List<RequestedArtifacts.Request> runtimeDataForKey;
            boolean isAllArtifacts = Long.valueOf((String)config.get((Object)artifactKey)).equals(-1L);
            if (isAllArtifacts || !CollectionUtils.isEmpty(runtimeDataForKey = requestedArtifactContexts.getRequestsForKeyIndex(keyIndex = ArtifactDownloaderTaskConfigurationHelper.getIndexFromKey((String)artifactKey)))) continue;
            String artifactName = (String)config.get((Object)ArtifactDownloaderTaskConfigurationHelper.getArtifactNameKey((int)keyIndex));
            String errorMessage = "Data for artifact " + (Serializable)(artifactName != null ? artifactName : Integer.valueOf(keyIndex)) + " is missing from runtime context";
            buildLogger.addErrorLogEntry(errorMessage);
        }
        for (RequestedArtifacts.Request downloadRequest : requestedArtifactContexts.getAllRequests()) {
            ArtifactDefinitionContext artifactContext = downloadRequest.getContext();
            String localPath = downloadRequest.getLocalPath();
            Stopwatch stopWatch = Stopwatch.createStarted();
            buildLogger.addBuildLogEntry("Preparing to download plan result " + planResultKey + " artifact: " + artifactContext);
            Map artifactHandlerConfiguration = BuildContextHelper.getArtifactHandlerConfiguration((CommonContext)taskContext.getCommonContext());
            artifactHandlerConfiguration.put("ARTIFACT_SECURITY_TOKEN", securityToken);
            boolean downloadResult = this.artifactManager.retrieve(buildLogger, planResultKey, taskContext.getCommonContext().getResultKey(), artifactContext, localPath, artifactHandlerConfiguration, BuildContextHelper.getBuildWorkingDirectory((CommonContext)taskContext.getCommonContext()), this.getAvailableArtifacts(taskContext));
            if (!downloadResult) {
                String errorMessage = "Unable to download artifact " + artifactContext;
                buildLogger.addErrorLogEntry(errorMessage);
                continue;
            }
            String niceLocalPath = StringUtils.isNotEmpty((CharSequence)localPath) ? UrlUtils.appendSlashIfDoesntExist((String)localPath) : "working directory";
            buildLogger.addBuildLogEntry("Artifact [" + artifactContext.getName() + "] downloaded successfully in " + stopWatch + " to " + niceLocalPath);
        }
        return taskResultBuilder.setState(TaskState.SUCCESS).build();
    }

    private void dumpConfigurationToLog(BuildLogger buildLogger, CommonTaskContext taskContext) {
        ConfigurationMap configurationMap = taskContext.getConfigurationMap();
        buildLogger.addBuildLogEntry("Task configuration:");
        for (Map.Entry entry : configurationMap.entrySet()) {
            buildLogger.addBuildLogEntry((String)entry.getKey() + " -> [" + (String)entry.getValue() + "]");
        }
        Map runtimeContext = taskContext.getRuntimeTaskContext();
        buildLogger.addBuildLogEntry("Task runtime configuration:");
        for (Map.Entry entry : runtimeContext.entrySet()) {
            buildLogger.addBuildLogEntry((String)entry.getKey() + " -> [" + (String)entry.getValue() + "]");
        }
    }

    @Nullable
    private Multimap<String, Artifact> getAvailableArtifacts(CommonTaskContext taskContext) {
        DeploymentTaskContext deploymentTaskContext = (DeploymentTaskContext)Narrow.downTo((Object)taskContext, DeploymentTaskContext.class);
        if (deploymentTaskContext != null) {
            return deploymentTaskContext.getDeploymentContext().getVersionArtifacts();
        }
        AvailableArtifacts availableArtifacts = (AvailableArtifacts)Narrow.reinterpret(taskContext.getRuntimeTaskData().get("availableArtifacts"), AvailableArtifacts.class);
        return availableArtifacts.getArtifacts();
    }
}

