/*
 * Decompiled with CFR 0.152.
 */
package com.fouroaksconsulting.tools.jdabambooplugin.task;

import com.atlassian.bamboo.build.artifact.ArtifactLinkManager;
import com.atlassian.bamboo.build.artifact.ArtifactManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.storage.StorageLocationService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.core.util.FileUtils;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ProcessException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class InstallRolloutUnixTask
implements TaskType {
    private ProcessService processService;
    private ArtifactManager artifactManager;
    private StorageLocationService storageLocationService;
    private ArtifactLinkManager artifactLinkManager;
    private ResultsSummaryManager resultsSummaryManager;

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }

    public void setArtifactManager(ArtifactManager artifactManager) {
        this.artifactManager = artifactManager;
    }

    public void setStorageLocationService(StorageLocationService storageLocationService) {
        this.storageLocationService = storageLocationService;
    }

    public void setArtifactLinkManager(ArtifactLinkManager artifactLinkManager) {
        this.artifactLinkManager = artifactLinkManager;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        BuildLogger buildLogger = taskContext.getBuildLogger();
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        File rolloutArtifactDir = null;
        Collection artifactDefinitionContexts = taskContext.getBuildContext().getArtifactContext().getDefinitionContexts();
        for (ArtifactDefinitionContext artifactDefinitionContext : artifactDefinitionContexts) {
            rolloutArtifactDir = new File(taskContext.getWorkingDirectory(), artifactDefinitionContext.getLocation());
        }
        File lesTempDir = new File("/home/wms1/JDA_TEST/WM-WH1-DEV/les/temp");
        try {
            FileUtils.copyDirectory(rolloutArtifactDir, (File)lesTempDir);
        }
        catch (IOException e) {
            buildLogger.addErrorLogEntry("Could not copy rollout to LES/temp directory. Exiting build... " + e.getLocalizedMessage());
            return taskResultBuilder.failed().build();
        }
        String rolloutName = ((VariableDefinitionContext)taskContext.getBuildContext().getParentBuildContext().getVariableContext().getEffectiveVariables().get("rollout.name")).getValue();
        File lesTempRolloutDir = new File(lesTempDir, rolloutName);
        ArrayList<CallSite> cmdListRunPerlRollout = new ArrayList<CallSite>();
        String user = (String)taskContext.getConfigurationMap().get((Object)"username");
        cmdListRunPerlRollout.add((CallSite)((Object)("/etc/ksh sudo -s -u " + user + "; cd $LESDIR/temp/" + rolloutName + " ; perl rollout.pl " + rolloutName)));
        ExternalProcess processPerl = this.processService.createExternalProcess((CommonTaskContext)taskContext, new ExternalProcessBuilder().command(cmdListRunPerlRollout).workingDirectory(lesTempRolloutDir));
        processPerl.execute();
        InputStream inputStream = null;
        try {
            processPerl.getHandler().processOutput(inputStream);
        }
        catch (ProcessException e) {
            e.printStackTrace();
        }
        if (processPerl.getHandler().getExitCode() == 0 || processPerl.getHandler().getExitCode() == 2) {
            return taskResultBuilder.success().build();
        }
        return taskResultBuilder.failed().build();
    }
}

