/*
 * Decompiled with CFR 0.152.
 */
package com.fouroaksconsulting.tools.jdabambooplugin.task;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.resultsummary.ResultDataRead;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskState;
import com.fouroaksconsulting.tools.jdabambooplugin.task.util.AbstractBuildRolloutTask;
import com.fouroaksconsulting.tools.jdabambooplugin.task.util.ReadMeFile;
import com.fouroaksconsulting.tools.jdabambooplugin.task.util.RolloutFile;
import com.fouroaksconsulting.tools.jdabambooplugin.task.util.RolloutScript;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.springframework.util.AntPathMatcher;

public class BuildRolloutTask
extends AbstractBuildRolloutTask {
    public static final String ROLLOUT_PL = "rollout.pl";
    public static final String PKG_DIR = "pkg";

    @Override
    public String getPackageSubDir() {
        return PKG_DIR;
    }

    @Override
    public String getPackageRootDir(TaskContext taskContext) {
        return "";
    }

    @Override
    public TaskState packageRollout(TaskContext taskContext, List<RolloutFile> rolloutFileList, List<RolloutFile> rolloutFileListToAdd, String rolloutName, File rolloutDirectory, BuildLogger buildLogger, TaskResultBuilder taskResultBuilder, PlanResultKey planResultKey, String packageSubDir, String jiraVersion, File checkoutDirectory) {
        String filename = null;
        try {
            RolloutScript.create(taskContext, rolloutFileList, rolloutName, rolloutDirectory.toString());
            if (!this.addRolloutPerlScript(taskContext, rolloutName, rolloutDirectory.toString(), checkoutDirectory)) {
                buildLogger.addErrorLogEntry("Error adding rollout.pl file. Make sure the rollout.pl file is in the LES\\scripts directory and in the version controlled repository");
                return TaskState.ERROR;
            }
            filename = "readme.txt";
            ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(planResultKey, ResultDataRead.EAGER);
            List linkedJiraIssueList = this.jiraIssueResultsManager.findJiraIssuesForBuildResults(Arrays.asList(resultsSummary));
            ReadMeFile.create(rolloutFileList, rolloutName, rolloutDirectory.toString(), linkedJiraIssueList, taskContext, false);
        }
        catch (IOException e) {
            buildLogger.addErrorLogEntry("Error adding file " + filename + ": " + e.getMessage());
            return TaskState.ERROR;
        }
        return TaskState.SUCCESS;
    }

    @Override
    public boolean filterRolloutFileListForIncludePaths(TaskContext taskContext, List<RolloutFile> rolloutFileList, BuildLogger buildLogger) {
        String inclPatternString = (String)taskContext.getConfigurationMap().get((Object)"inclPattern");
        String exclPattermString = (String)taskContext.getConfigurationMap().get((Object)"exclPattern");
        if (!inclPatternString.isEmpty() || !exclPattermString.isEmpty()) {
            ArrayList<RolloutFile> filteredRolloutFileList = new ArrayList<RolloutFile>();
            if (inclPatternString.isEmpty()) {
                inclPatternString = "**";
            }
            List<String> inclPatternList = Arrays.asList(inclPatternString.split(","));
            List<String> exclPatternList = Arrays.asList(exclPattermString.split(","));
            AntPathMatcher antPathMatcher = new AntPathMatcher("/");
            for (RolloutFile rolloutFile : rolloutFileList) {
                boolean fileIncluded = false;
                for (String inclPattern : inclPatternList) {
                    if (!antPathMatcher.match(inclPattern, rolloutFile.getCommitFile().getName())) continue;
                    fileIncluded = true;
                }
                boolean fileExcluded = false;
                for (String exclPattern : exclPatternList) {
                    if (!antPathMatcher.match(exclPattern, rolloutFile.getCommitFile().getName())) continue;
                    fileExcluded = true;
                }
                if (!fileIncluded || fileExcluded) continue;
                filteredRolloutFileList.add(rolloutFile);
            }
            rolloutFileList.clear();
            if (!filteredRolloutFileList.isEmpty()) {
                rolloutFileList.addAll(filteredRolloutFileList);
            }
        }
        return true;
    }

    protected boolean addRolloutPerlScript(TaskContext taskContext, String rolloutName, String workingDirectory, File checkoutDirectory) throws IOException {
        String rolloutPlFileName = (String)taskContext.getConfigurationMap().get((Object)"rolloutPlPath");
        if (rolloutPlFileName.isEmpty()) {
            rolloutPlFileName = "**/scripts/rollout.pl";
        }
        File rolloutPlDest = new File(workingDirectory.concat("\\rollout.pl"));
        FileSet fileSet = new FileSet();
        PatternSet.NameEntry include = fileSet.createInclude();
        include.setName(rolloutPlFileName);
        fileSet.setDir(checkoutDirectory);
        Project fileSetProject = new Project();
        fileSet.setProject(fileSetProject);
        Object[] files = fileSet.getDirectoryScanner(fileSetProject).getIncludedFiles();
        if (!ArrayUtils.isEmpty((Object[])files)) {
            File rolloutPlSource = new File(checkoutDirectory, (String)files[0]);
            FileUtils.copyFile((File)rolloutPlSource, (File)rolloutPlDest, (boolean)true);
            return true;
        }
        return false;
    }
}

