/*
 * Decompiled with CFR 0.152.
 */
package com.fouroaksconsulting.tools.jdabambooplugin.task;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.resultsummary.ResultDataRead;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskState;
import com.fouroaksconsulting.tools.jdabambooplugin.task.util.AbstractBuildRolloutTask;
import com.fouroaksconsulting.tools.jdabambooplugin.task.util.ReadMeFile;
import com.fouroaksconsulting.tools.jdabambooplugin.task.util.RolloutFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.springframework.util.AntPathMatcher;

public class BuildRolloutRefsTask
extends AbstractBuildRolloutTask {
    public static final String CHANGES_DIR = "changes/deploy";
    public static final String DEPLOY_CMD_WIN = "deploy.cmd";
    public static final String DEPLOY_CMD_UNIX = "deploy";
    private static final String CHANGES_ZIP_FILE_NAME = "changes.zip";

    @Override
    public String getPackageSubDir() {
        return CHANGES_DIR;
    }

    @Override
    public String getPackageRootDir(TaskContext taskContext) {
        return (String)taskContext.getConfigurationMap().get((Object)"deployDirInLes");
    }

    @Override
    public boolean filterRolloutFileListForIncludePaths(TaskContext taskContext, List<RolloutFile> rolloutFileList, BuildLogger buildLogger) {
        String inclPatternString = (String)taskContext.getConfigurationMap().get((Object)"deployDirInLes") + "/**";
        if (inclPatternString.isEmpty()) {
            buildLogger.addErrorLogEntry("REFS deploy directory not defined, failing the build. Please setup the Refs Deploy Directory in the Build REFS Rollout Task");
            return false;
        }
        ArrayList<RolloutFile> filteredRolloutFileList = new ArrayList<RolloutFile>();
        List<String> inclPatternList = Arrays.asList(inclPatternString.split(","));
        AntPathMatcher antPathMatcher = new AntPathMatcher("/");
        for (RolloutFile rolloutFile : rolloutFileList) {
            boolean fileIncluded = false;
            for (String inclPattern : inclPatternList) {
                if (!antPathMatcher.match(inclPattern, rolloutFile.getCommitFile().getName())) continue;
                fileIncluded = true;
            }
            if (!fileIncluded) continue;
            filteredRolloutFileList.add(rolloutFile);
        }
        rolloutFileList.clear();
        if (!filteredRolloutFileList.isEmpty()) {
            rolloutFileList.addAll(filteredRolloutFileList);
        }
        return true;
    }

    @Override
    public TaskState packageRollout(TaskContext taskContext, List<RolloutFile> rolloutFileList, List<RolloutFile> rolloutFileListToAdd, String rolloutName, File rolloutDirectory, BuildLogger buildLogger, TaskResultBuilder taskResultBuilder, PlanResultKey planResultKey, String packageSubDir, String jiraVersion, File checkoutDirectory) {
        ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(planResultKey, ResultDataRead.EAGER);
        List linkedJiraIssueList = this.jiraIssueResultsManager.findJiraIssuesForBuildResults(Arrays.asList(resultsSummary));
        if (!this.createChangesZipFile(rolloutDirectory, rolloutFileListToAdd, buildLogger)) {
            return TaskState.ERROR;
        }
        if (!this.addDeployJars(checkoutDirectory, rolloutDirectory, taskContext, buildLogger)) {
            return TaskState.ERROR;
        }
        if (!this.addDeletionsFile(rolloutFileList, rolloutDirectory, buildLogger)) {
            return TaskState.ERROR;
        }
        if (!this.addDeployFiles(rolloutDirectory, buildLogger)) {
            return TaskState.ERROR;
        }
        if (!this.addReadMeFile(rolloutFileList, rolloutName, rolloutDirectory, taskContext, linkedJiraIssueList, buildLogger)) {
            return TaskState.ERROR;
        }
        if (!this.addPropertiesFile(rolloutDirectory, rolloutName, linkedJiraIssueList, jiraVersion, buildLogger)) {
            return TaskState.ERROR;
        }
        return TaskState.SUCCESS;
    }

    private boolean createChangesZipFile(File rolloutDirectory, List<RolloutFile> rolloutFileListToAdd, BuildLogger buildLogger) {
        FileOutputStream fos;
        Path destinationFilePath = Paths.get(rolloutDirectory.getPath(), CHANGES_ZIP_FILE_NAME);
        try {
            fos = new FileOutputStream(destinationFilePath.toFile());
        }
        catch (FileNotFoundException e) {
            buildLogger.addErrorLogEntry("Error opening Zip File: " + e.getMessage());
            return false;
        }
        ZipOutputStream zipOut = new ZipOutputStream(fos);
        Path fileToZipPath = Paths.get(rolloutDirectory.toString(), CHANGES_DIR);
        File filetoZip = fileToZipPath.toFile();
        try {
            this.zipFile(filetoZip, fileToZipPath.getFileName().toString(), zipOut, false, buildLogger);
            zipOut.close();
            fos.close();
        }
        catch (IOException e) {
            buildLogger.addErrorLogEntry("Error creating Zip File: " + e.getMessage());
            return false;
        }
        try {
            if (filetoZip.exists()) {
                if (filetoZip.isDirectory()) {
                    FileUtils.deleteDirectory((File)filetoZip);
                } else {
                    FileUtils.delete((File)filetoZip);
                }
            }
        }
        catch (SecurityException e) {
            buildLogger.addErrorLogEntry("Error removing zipped files: " + e.getMessage());
            return false;
        }
        catch (IOException e) {
            buildLogger.addErrorLogEntry("Error removing zipped files: " + e.getMessage());
            return false;
        }
        return true;
    }

    private void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut, boolean includeDirs, BuildLogger buildLogger) throws IOException {
        int length;
        if (fileToZip.isDirectory()) {
            File[] children;
            if (includeDirs) {
                if (fileName.endsWith("/")) {
                    zipOut.putNextEntry(new ZipEntry(fileName));
                    zipOut.closeEntry();
                } else {
                    zipOut.putNextEntry(new ZipEntry(fileName + "/"));
                    zipOut.closeEntry();
                }
            }
            for (File childFile : children = fileToZip.listFiles()) {
                this.zipFile(childFile, fileName + "/" + childFile.getName(), zipOut, false, buildLogger);
            }
            return;
        }
        FileInputStream fis = null;
        fis = new FileInputStream(fileToZip);
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOut.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
        fis.close();
    }

    private boolean addDeployJars(File checkoutDirectory, File rolloutDirectory, TaskContext taskContext, BuildLogger buildlogger) {
        String[] jarFileList = new String[]{"commons-cli-*.jar", "commons-collections*.jar", "commons-io-*.jar", "commons-lang*.jar", "csbuilder.jar", "deploy.jar", "xmappr*.jar"};
        Path jarDestinationDir = Paths.get(rolloutDirectory.getPath(), "bin");
        FileSet fileSet = new FileSet();
        String jarSourcePathInLES = (String)taskContext.getConfigurationMap().get((Object)"deployRefsJarPath");
        File jarSourceDir = Paths.get(checkoutDirectory.toString(), jarSourcePathInLES).toFile();
        fileSet.setDir(jarSourceDir);
        Project fileSetProject = new Project();
        fileSet.setProject(fileSetProject);
        for (String jarFileName : jarFileList) {
            fileSet.createInclude().setName(jarFileName);
        }
        String[] filesFound = fileSet.getDirectoryScanner(fileSetProject).getIncludedFiles();
        if (filesFound.length == 0) {
            buildlogger.addErrorLogEntry("Deploy jar files not found in repository. Make sure that the .jar files from a BY Refs Hotfix are committed to the Repository and specify the location of these files in the Task Build REFS Rollout");
            return false;
        }
        try {
            for (String fileName : filesFound) {
                File jarSourceFile = Paths.get(fileSet.getDir(fileSetProject).toString(), fileName).toFile();
                File jarDestinationFile = Paths.get(jarDestinationDir.toString(), fileName).toFile();
                FileUtils.copyFile((File)jarSourceFile, (File)jarDestinationFile, (boolean)true);
            }
        }
        catch (IOException ioException) {
            buildlogger.addErrorLogEntry("Error adding deploy jar files: " + ioException.getMessage());
            return false;
        }
        return true;
    }

    private boolean addDeletionsFile(List<RolloutFile> rolloutFileList, File rolloutDirectory, BuildLogger buildLogger) {
        List rolloutFileListToDelete = rolloutFileList.stream().filter(x -> x.getFileAction().equals(RolloutFile.DELETED)).collect(Collectors.toList());
        List<String> fileListToDelete = rolloutFileListToDelete.stream().map(RolloutFile::getFileName).collect(Collectors.toList());
        return this.addFileToRollout("deletions.txt", fileListToDelete, rolloutDirectory, buildLogger);
    }

    private boolean addDeployFiles(File rolloutDirectory, BuildLogger buildLogger) {
        ArrayList<String> deployCommandWin = new ArrayList<String>();
        deployCommandWin.add("java -jar bin/deploy.jar -to %REFSDIR% %*");
        if (!this.addFileToRollout(DEPLOY_CMD_WIN, deployCommandWin, rolloutDirectory, buildLogger)) {
            return false;
        }
        ArrayList<String> deployCommandUnix = new ArrayList<String>();
        deployCommandUnix.add("java -jar bin/deploy.jar -to $REFSDIR $*");
        return this.addFileToRollout(DEPLOY_CMD_UNIX, deployCommandUnix, rolloutDirectory, buildLogger);
    }

    private boolean addReadMeFile(List<RolloutFile> rolloutFileList, String rolloutName, File rolloutDirectory, TaskContext taskContext, List<LinkedJiraIssue> linkedJiraIssueList, BuildLogger buildLogger) {
        try {
            ReadMeFile.create(rolloutFileList, rolloutName, rolloutDirectory.toString(), linkedJiraIssueList, taskContext, true);
        }
        catch (IOException e) {
            buildLogger.addErrorLogEntry("Error creating README.txt file: " + e.getMessage());
            return false;
        }
        return true;
    }

    private boolean addPropertiesFile(File rolloutDirectory, String rolloutName, List<LinkedJiraIssue> linkedJiraIssueList, String jiraVersion, BuildLogger buildLogger) {
        ArrayList<String> props = new ArrayList<String>();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSS");
        props.add("#Tracking info for " + rolloutName);
        props.add("# " + LocalDateTime.now());
        props.add("version=" + jiraVersion);
        props.add("issues=" + linkedJiraIssueList.toString());
        props.add("name=" + rolloutName);
        props.add("tracking-path=deploy/rollouts");
        props.add("description=");
        props.add("product=WM Web Client");
        props.add("created=" + LocalDateTime.now().format(dtf));
        String fileName = rolloutName + ".properties";
        return this.addFileToRollout(fileName, props, rolloutDirectory, buildLogger);
    }

    private boolean addFileToRollout(String fileName, List<String> fileContent, File rolloutSubDirectory, BuildLogger buildlogger) {
        File newFile = new File(rolloutSubDirectory, fileName);
        try {
            newFile.createNewFile();
        }
        catch (IOException e) {
            buildlogger.addErrorLogEntry("Error creating file [" + newFile.getName() + "]: " + e.getMessage());
            return false;
        }
        try {
            Files.write(newFile.toPath(), fileContent, Charset.forName("UTF-8"), new OpenOption[0]);
        }
        catch (IOException e) {
            buildlogger.addErrorLogEntry("Error writing to file [" + newFile.getName() + "]: " + e.getMessage());
            return false;
        }
        return true;
    }
}

