/*
 * Decompiled with CFR 0.152.
 */
package com.fouroaksconsulting.tools.jdabambooplugin.preChain;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.AuthorContext;
import com.atlassian.bamboo.author.AuthorCreatorServiceImpl;
import com.atlassian.bamboo.author.ExtendedAuthor;
import com.atlassian.bamboo.author.ExtendedAuthorManager;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.chains.BuildExecution;
import com.atlassian.bamboo.chains.ChainExecution;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.StageExecution;
import com.atlassian.bamboo.chains.plugins.PreChainAction;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.commit.CommitImpl;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueLinkType;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssueImpl;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfiguration;
import com.atlassian.bamboo.plan.branch.BranchIntegrationService;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultSummaryHelper;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCreationException;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangesetImpl;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.BuildRepositoryChangesImpl;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.sal.api.message.I18nResolver;
import com.fouroaksconsulting.tools.jdabambooplugin.task.util.CustomGitExecutor;
import com.fouroaksconsulting.tools.jdabambooplugin.task.util.CustomSvnExecutor;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class UpdateBuildResultPreChain
implements PreChainAction {
    public static final String BUILD_ROLLLOUT_TASK_KEY = "com.fouroaksconsulting.tools.jdabambooplugin:task.jdabambooplugin.buildrollout";
    public static final String BUILD_ROLLLOUT_REFS_TASK_KEY = "com.fouroaksconsulting.tools.jdabambooplugin:task.jdabambooplugin.buildRefsRollout";
    private String jiraIssueKeyString;
    private ResultsSummaryManager resultsSummaryManager;
    private BuildLoggerManager buildLoggerManager;
    private VcsRepositoryManager vcsRepositoryManager;
    private RepositoryDefinitionManager repositoryDefinitionManager;
    private BranchIntegrationService branchIntegrationService;
    private I18nResolver i18nResolver;
    private CustomVariableContext customVariableContext;
    private BuildDirectoryManager buildDirectoryManager;
    private TrustedKeyHelper trustedKeyHelper;
    private SshProxyService sshProxyService;
    private CapabilityContext capabilityContext;
    private CredentialsAccessor credentialsAccessor;
    private ExtendedAuthorManager extendedAuthorManager;

    public void setCapabilityContext(CapabilityContext capabilityContext) {
        this.capabilityContext = capabilityContext;
    }

    public void setCredentialsAccessor(CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    public void setBuildDirectoryManager(BuildDirectoryManager buildDirectoryManager) {
        this.buildDirectoryManager = buildDirectoryManager;
    }

    public void setTrustedKeyHelper(TrustedKeyHelper trustedKeyHelper) {
        this.trustedKeyHelper = trustedKeyHelper;
    }

    public void setSshProxyService(SshProxyService sshProxyService) {
        this.sshProxyService = sshProxyService;
    }

    public void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }

    public void setVcsRepositoryManager(VcsRepositoryManager vcsRepositoryManager) {
        this.vcsRepositoryManager = vcsRepositoryManager;
    }

    public void setRepositoryDefinitionManager(RepositoryDefinitionManager repositoryDefinitionManager) {
        this.repositoryDefinitionManager = repositoryDefinitionManager;
    }

    public void setBranchIntegrationService(BranchIntegrationService branchIntegrationService) {
        this.branchIntegrationService = branchIntegrationService;
    }

    public void setExtendedAuthorManager(ExtendedAuthorManager extendedAuthorManager) {
        this.extendedAuthorManager = extendedAuthorManager;
    }

    public void execute(@NotNull ImmutableChain immutableChain, @NotNull ChainExecution chainExecution) throws Exception {
        Boolean isRunThisPreChainCode = false;
        if (chainExecution.getTriggerReason().getKey().equals("com.fouroaksconsulting.tools.jdabambooplugin:jiraReleaseWmsTriggerReason")) {
            isRunThisPreChainCode = true;
        }
        if (isRunThisPreChainCode.booleanValue()) {
            PlanResultKey planResultKey = chainExecution.getPlanResultKey();
            ChainResultsSummary chainResultsSummary = (ChainResultsSummary)this.resultsSummaryManager.getResultsSummary(planResultKey);
            BuildLogger buildLogger = immutableChain.getBuildLogger();
            String jiraIssuesString = (String)chainResultsSummary.getCustomBuildData().get("triggerReason.jiraIssues");
            if (jiraIssuesString == null || jiraIssuesString.isEmpty()) {
                buildLogger.addErrorLogEntry("Can't find JIRA issues. Possible connection issue with JIRA server.");
                chainResultsSummary.setContinuable(false);
                return;
            }
            ArrayList<String> jiraIssueKeyList = new ArrayList<String>(Arrays.asList(jiraIssuesString.split(",")));
            PlanRepositoryDefinition planRepositoryDefinition = null;
            for (PlanRepositoryDefinition checkPlanRepositoryDefinition : immutableChain.getPlanRepositoryDefinitions()) {
                if (checkPlanRepositoryDefinition.getPosition() != 0) continue;
                planRepositoryDefinition = checkPlanRepositoryDefinition;
            }
            if (planRepositoryDefinition == null) {
                buildLogger.addErrorLogEntry("No repository defined for plan. Please define a repository and trigger the build again.");
                chainResultsSummary.setContinuable(false);
                return;
            }
            VcsRepositoryModuleDescriptor moduleDescriptor = this.getModuleDescriptor(planRepositoryDefinition);
            VcsRepositoryData vcsRepositoryData = this.repositoryDefinitionManager.getVcsRepositoryData(planRepositoryDefinition.getId());
            BuildContext buildContext = ((BuildExecution)((StageExecution)chainExecution.getStages().get(0)).getBuilds().get(0)).getBuildContext();
            CommonContext commonContext = (CommonContext)Narrow.downTo((Object)buildContext, CommonContext.class);
            File planCheckoutDirectory = UpdateBuildResultPreChain.getRepoWorkingDirectory(this.buildDirectoryManager, planResultKey, planRepositoryDefinition);
            buildLogger.addBuildLogEntry("Retrieving or updating source code to local directory " + planCheckoutDirectory + " First time checkout for this plan takes longer, subsequent updates should be faster. ");
            moduleDescriptor.getWorkingCopyManager().updateToLatestRevision(commonContext, vcsRepositoryData, planCheckoutDirectory);
            buildLogger.addBuildLogEntry("Done retrieving or updating source code.");
            BuildRepositoryChangesImpl buildRepositoryChanges = new BuildRepositoryChangesImpl();
            String vcsTypeString = moduleDescriptor.getTypeString();
            if (vcsTypeString.equalsIgnoreCase("bbCloud") || vcsTypeString.equalsIgnoreCase("bb") || vcsTypeString.equalsIgnoreCase("gh2") || vcsTypeString.equalsIgnoreCase("gitv2")) {
                CustomGitExecutor customGitExecutor = new CustomGitExecutor(this.capabilityContext, this.credentialsAccessor, this.customVariableContext, this.buildDirectoryManager, this.i18nResolver, this.trustedKeyHelper, this.sshProxyService, null, vcsRepositoryData);
                buildRepositoryChanges = customGitExecutor.getBuildChangesforJiraIssues(jiraIssueKeyList, planCheckoutDirectory, buildLogger, planRepositoryDefinition.getId(), null);
            } else if (vcsTypeString.equalsIgnoreCase("svnv2")) {
                CustomSvnExecutor customSvnExecutor = new CustomSvnExecutor();
                buildRepositoryChanges = customSvnExecutor.getBuildChangesForJiraIssues(vcsRepositoryData, jiraIssueKeyList);
            }
            List<String> jiraIssueKeyListUpdated = this.getJiraIssuesInCommits((BuildRepositoryChanges)buildRepositoryChanges, jiraIssueKeyList);
            this.updateResultSummaryJiraIssues(jiraIssueKeyListUpdated, planResultKey);
            chainExecution.getBuildChanges().addRepositoryChanges((BuildRepositoryChanges)buildRepositoryChanges);
            chainResultsSummary.getRepositoryChangesets().clear();
            List<RepositoryChangeset> changesets = this.getRepositoryChangesets(chainResultsSummary, (BuildRepositoryChanges)buildRepositoryChanges);
            if (changesets != null) {
                chainResultsSummary.getRepositoryChangesets().addAll(changesets);
            }
            this.resultsSummaryManager.saveResultSummary((ResultsSummary)chainResultsSummary);
            chainExecution.getBuildChanges().setChanges(buildRepositoryChanges.getRepositoryId(), buildRepositoryChanges.getChanges());
        }
    }

    private List<String> getJiraIssuesInCommits(BuildRepositoryChanges buildRepositoryChanges, List<String> jiraIssuesList) {
        ArrayList<String> jiraIssueKeyListUpdated = new ArrayList<String>();
        for (CommitContext commitContext : buildRepositoryChanges.getChanges()) {
            for (String jiraKey : jiraIssuesList) {
                if (!commitContext.getComment().contains(jiraKey)) continue;
                jiraIssueKeyListUpdated.add(jiraKey);
            }
        }
        return jiraIssueKeyListUpdated;
    }

    private List<RepositoryChangeset> getRepositoryChangesets(ChainResultsSummary resultsSummary, BuildRepositoryChanges repositoryChanges) throws ResultsSummaryCreationException {
        RepositoryDataEntity repositoryDataEntity;
        long repositoryId;
        ArrayList<RepositoryChangeset> repositoryChangesets = new ArrayList<RepositoryChangeset>();
        ImmutableChain plan = resultsSummary.getImmutablePlan();
        List chainRepositories = plan.getPlanRepositoryDefinitions();
        BranchIntegrationConfiguration branchIntegrationConfiguration = plan.getBuildDefinition().getBranchIntegrationConfiguration();
        VcsRepositoryData integrationRepositoryDefinition = null;
        if (branchIntegrationConfiguration.isEnabled()) {
            integrationRepositoryDefinition = this.branchIntegrationService.getIntegrationRepository((ImmutablePlan)plan);
        }
        if ((repositoryId = repositoryChanges.getRepositoryId()) == -1L) {
            // empty if block
        }
        if ((repositoryDataEntity = this.repositoryDefinitionManager.getRepositoryDataEntity(repositoryId)) == null) {
            throw new ResultsSummaryCreationException(String.format("Build changes refer repository id %d which does not exist in the database", repositoryId));
        }
        PlanRepositoryDefinition repositoryDefinition = (PlanRepositoryDefinition)chainRepositories.stream().collect(Collectors.toMap(BambooIdProvider::getId, Function.identity())).get(repositoryId);
        if (repositoryDefinition != null || integrationRepositoryDefinition == null || repositoryId == integrationRepositoryDefinition.getId()) {
            // empty if block
        }
        if (repositoryDefinition == null && !ResultSummaryHelper.isBambooSpecResult((ImmutableResultsSummary)resultsSummary)) {
            throw new ResultsSummaryCreationException(String.format("Build changes refer repository id %d which does not exist in the plan", repositoryId));
        }
        int position = repositoryDefinition == null ? 0 : chainRepositories.indexOf(repositoryDefinition);
        RepositoryChangesetImpl repositoryChangeset = new RepositoryChangesetImpl(repositoryDataEntity, (ResultsSummary)resultsSummary, repositoryChanges.getVcsRevisionKey(), (long)repositoryChanges.getSkippedCommitsCount(), position, false);
        for (CommitContext commit : repositoryChanges.getChanges()) {
            Commit processedCommit = this.generateCommitFromChangeLogs(commit, (RepositoryChangeset)repositoryChangeset);
            repositoryChangeset.getCommits().add(processedCommit);
        }
        repositoryChangesets.add((RepositoryChangeset)repositoryChangeset);
        return repositoryChangesets;
    }

    private Commit generateCommitFromChangeLogs(CommitContext changeLogEntry, RepositoryChangeset repositoryChangeset) {
        CommitImpl commit = new CommitImpl();
        commit.setDate(changeLogEntry.getDate());
        commit.setChangeSetId(changeLogEntry.getChangeSetId());
        commit.setRepositoryChangeset(repositoryChangeset);
        commit.setComment(changeLogEntry.getComment());
        commit.setFiles(changeLogEntry.getFiles());
        commit.setForeignCommit(changeLogEntry.isForeignCommit());
        String authorName = StringUtils.defaultString((String)changeLogEntry.getAuthorContext().getName()).trim();
        ExtendedAuthor author = this.extendedAuthorManager.getExtendedAuthorByName(authorName);
        if (author == null) {
            AuthorCreatorServiceImpl authorCreatorService = new AuthorCreatorServiceImpl();
            AuthorContext authorContext = changeLogEntry.getAuthorContext();
            authorCreatorService.createAuthorIfMissing(authorContext);
            author = this.extendedAuthorManager.getExtendedAuthorByName(authorName);
        }
        commit.setAuthor((Author)author);
        return commit;
    }

    private void updateResultSummaryJiraIssues(List<String> jiraIssueKeyList, PlanResultKey planResultKey) {
        ChainResultsSummary chainResultsSummary = (ChainResultsSummary)this.resultsSummaryManager.getResultsSummary(planResultKey);
        chainResultsSummary.getJiraIssues().clear();
        for (String jiraIssueKey : jiraIssueKeyList) {
            LinkedJiraIssueImpl linkedJiraIssue = new LinkedJiraIssueImpl(jiraIssueKey, JiraIssueLinkType.BUILD_RELATES);
            linkedJiraIssue.setResultsSummary((ResultsSummary)chainResultsSummary);
            chainResultsSummary.getJiraIssues().add(linkedJiraIssue);
        }
    }

    private VcsRepositoryModuleDescriptor getModuleDescriptor(@NotNull PlanRepositoryDefinition planRepositoryDefinition) {
        return (VcsRepositoryModuleDescriptor)Preconditions.checkNotNull((Object)this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(planRepositoryDefinition.getPluginKey()), (Object)("Can't find change detector class for repository plugin " + planRepositoryDefinition.getPluginKey()));
    }

    public static File getRepoWorkingDirectory(BuildDirectoryManager buildDirectoryManager, PlanResultKey planResultKey, PlanRepositoryDefinition planRepositoryDefinition) {
        File workDirBuild = buildDirectoryManager.getBuildWorkingDirectory(planResultKey.getEntityKey());
        return new File(workDirBuild, "WorkDirRepo-" + Long.toString(planRepositoryDefinition.getId()));
    }
}

