/*
 * Decompiled with CFR 0.152.
 */
package com.fouroaksconsulting.tools.jdabambooplugin.license;

import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.PluginController;
import com.atlassian.upm.api.license.PluginLicenseEventRegistry;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.license.event.PluginLicenseChangeEvent;
import com.atlassian.upm.api.license.event.PluginLicenseCheckEvent;
import com.atlassian.upm.api.license.event.PluginLicenseRemovedEvent;
import com.atlassian.upm.api.util.Option;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseChecker {
    private static final Logger log = LoggerFactory.getLogger(LicenseChecker.class);
    private final PluginController pluginController;
    private final PluginLicenseManager pluginLicenseManager;
    private final String pluginKey;

    public LicenseChecker(PluginController pluginController, PluginLicenseManager pluginLicenseManager, PluginLicenseEventRegistry pluginLicenseEventRegistry) {
        this.pluginController = pluginController;
        this.pluginLicenseManager = pluginLicenseManager;
        this.pluginKey = pluginLicenseManager.getPluginKey();
        pluginLicenseEventRegistry.register((Object)this);
    }

    @EventListener
    public void handleEvent(PluginLicenseCheckEvent event) {
        System.out.println("HANDING CHECK EVENT: " + event);
        this.checkLicense((Option<PluginLicense>)event.getLicense());
    }

    @EventListener
    public void handleEvent(PluginLicenseChangeEvent event) {
        System.out.println("HANDING CHANGE EVENT: " + event);
        this.checkLicense((Option<PluginLicense>)Option.some((Object)event.getLicense()));
    }

    @EventListener
    public void handleEvent(PluginLicenseRemovedEvent event) {
        System.out.println("HANDING REMOVE EVENT: " + event);
        this.checkLicense((Option<PluginLicense>)Option.none(PluginLicense.class));
    }

    private final void checkLicense(Option<PluginLicense> maybeLicense) {
        if (!this.isValidLicense(maybeLicense)) {
            log.warn("Disabling plugin '" + this.pluginKey + "'");
            this.pluginController.disablePlugin(this.pluginKey);
        }
    }

    private final boolean isValidLicense(Option<PluginLicense> maybeLicense) {
        Iterator iterator = maybeLicense.iterator();
        if (iterator.hasNext()) {
            PluginLicense license = (PluginLicense)iterator.next();
            if (!license.isValid()) {
                log.warn("Invalid license for plugin \"" + this.pluginKey + "\" (" + license.getError().getOrElse((Object)null) + ")");
                return false;
            }
            log.info("Validated license for plugin '" + this.pluginKey + "'");
            return true;
        }
        log.warn("No license available for plugin '" + this.pluginKey + "'");
        return false;
    }

    public boolean validateLicense() {
        Option license = this.pluginLicenseManager.getLicense();
        this.checkLicense((Option<PluginLicense>)license);
        return this.isValidLicense((Option<PluginLicense>)license);
    }
}

