/*
 * Decompiled with CFR 0.152.
 */
package com.fouroaksconsulting.tools.jdabambooplugin.customTriggerReason;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.bamboo.applinks.CredentialsRequiredContextException;
import com.atlassian.bamboo.applinks.JiraApplinksService;
import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.jira.rest.JiraRestResponse;
import com.atlassian.bamboo.jira.rest.JiraRestService;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.trigger.PlanTrigger;
import com.atlassian.bamboo.plan.trigger.PlanTriggerResult;
import com.atlassian.bamboo.plan.trigger.PlanTriggerResultBuilder;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionDataSet;
import com.atlassian.bamboo.repository.RepositoryBranchDeletedException;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.v2.trigger.ChangeDetectionManager;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.Request;
import com.fouroaksconsulting.tools.jdabambooplugin.customTriggerReason.JIRAReleaseWmsTriggerReason;
import com.opensymphony.webwork.dispatcher.json.JSONArray;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class JIRAReleaseWmsPlanTrigger
implements PlanTrigger {
    private static final Logger log = Logger.getLogger(JIRAReleaseWmsPlanTrigger.class);
    private final CachedPlanManager cachedPlanManager;
    private final ChangeDetectionManager changeDetectionManager;
    private VcsRepositoryManager vcsRepositoryManager;
    private RepositoryDefinitionManager repositoryDefinitionManager;
    private BuildDirectoryManager buildDirectoryManager;
    private JiraApplinksService jiraApplinksService;
    private JiraRestService jiraRestService;
    private VariableDefinitionManager variableDefinitionManager;
    private CredentialsAccessor credentialsAccessor;
    private CapabilityContext capabilityContext;
    private I18nResolver i18nResolver;
    private TrustedKeyHelper trustedKeyHelper;
    private SshProxyService sshProxyService;
    public String jiraIssues;
    public static final String JIRA_ISSUES_VARNAM = "jira.issues";
    public static final String JIRA_VERSION_VARNAM = "jira.version";

    @Autowired
    public JIRAReleaseWmsPlanTrigger(@BambooImport CachedPlanManager cachedPlanManager, @BambooImport ChangeDetectionManager changeDetectionManager, @BambooImport VcsRepositoryManager vcsRepositoryManager, @BambooImport RepositoryDefinitionManager repositoryDefinitionManager, @BambooImport BuildDirectoryManager buildDirectoryManager, @BambooImport JiraApplinksService jiraApplinksService, @BambooImport JiraRestService jiraRestService, @BambooImport VariableDefinitionManager variableDefinitionManager, @BambooImport CredentialsAccessor credentialsAccessor, @BambooImport CapabilityContext capabilityContext, @BambooImport I18nResolver i18nResolver, @BambooImport TrustedKeyHelper trustedKeyHelper, @BambooImport SshProxyService sshProxyService) {
        this.cachedPlanManager = cachedPlanManager;
        this.changeDetectionManager = changeDetectionManager;
        this.buildDirectoryManager = buildDirectoryManager;
        this.vcsRepositoryManager = vcsRepositoryManager;
        this.repositoryDefinitionManager = repositoryDefinitionManager;
        this.jiraApplinksService = jiraApplinksService;
        this.jiraRestService = jiraRestService;
        this.variableDefinitionManager = variableDefinitionManager;
        this.credentialsAccessor = credentialsAccessor;
        this.capabilityContext = capabilityContext;
        this.i18nResolver = i18nResolver;
        this.trustedKeyHelper = trustedKeyHelper;
        this.sshProxyService = sshProxyService;
    }

    @NotNull
    public PlanTriggerResult triggerPlan(@NotNull TriggerReason triggerReason, @NotNull PlanResultKey planResultKey, @NotNull Map<String, String> params, @NotNull Map<String, String> customVariables, @Nullable PlanVcsRevisionDataSet lastVcsRevisionKeys) {
        String errorMessage;
        PlanTriggerResultBuilder resultBuilder = PlanTriggerResultBuilder.create(customVariables);
        ImmutableChain chain = (ImmutableChain)this.cachedPlanManager.getPlanByKeyIfOfType(planResultKey.getPlanKey(), ImmutableChain.class);
        if (chain == null) {
            throw new IllegalStateException("Could not trigger a build with reason '" + triggerReason.getName() + "' because the plan '" + planResultKey.getPlanKey() + "' does not exist");
        }
        JIRAReleaseWmsTriggerReason jiraReleaseWmsTriggerReason = (JIRAReleaseWmsTriggerReason)((Object)Narrow.to((Object)triggerReason, JIRAReleaseWmsTriggerReason.class));
        if (jiraReleaseWmsTriggerReason != null) {
            resultBuilder.addVariable("jira.baseUrl", jiraReleaseWmsTriggerReason.getJiraBaseUrl());
            resultBuilder.addVariable("jira.projectKey", jiraReleaseWmsTriggerReason.getJiraProjectKey());
            resultBuilder.addVariable("jira.projectName", jiraReleaseWmsTriggerReason.getJiraProjectName());
            resultBuilder.addVariable(JIRA_VERSION_VARNAM, jiraReleaseWmsTriggerReason.getJiraVersionName());
            resultBuilder.addVariable("jira.username", jiraReleaseWmsTriggerReason.getJiraUsername());
            String jiraRestQuery = "rest/api/latest/search?jql=fixversion%3D" + jiraReleaseWmsTriggerReason.getJiraVersionName() + "&fields=fixVersions";
            List<String> jiraIssueKeyList = this.doJiraRestCallOnAllAppLinks(jiraRestQuery, resultBuilder);
            this.jiraIssues = String.join((CharSequence)",", jiraIssueKeyList);
            resultBuilder.addVariable(JIRA_ISSUES_VARNAM, this.jiraIssues);
            jiraReleaseWmsTriggerReason.setJiraIssues(this.jiraIssues);
        }
        try {
            BuildChanges buildChanges = this.changeDetectionManager.collectAllChangesSinceLastBuild(chain, customVariables, null);
            resultBuilder.addBuildChanges(buildChanges);
        }
        catch (RepositoryBranchDeletedException e) {
            errorMessage = "Could not detect changes for plan '" + planResultKey + "' with trigger '" + triggerReason.getName() + "': branch has been removed from VCS";
            resultBuilder.addErrorMessage(errorMessage);
        }
        catch (RepositoryException e) {
            errorMessage = "Could not detect changes for plan '" + planResultKey + "' with trigger '" + triggerReason.getName() + "'";
            log.error((Object)errorMessage, (Throwable)e);
            resultBuilder.addErrorMessage(errorMessage, (Exception)((Object)e));
        }
        return resultBuilder.build();
    }

    @NotNull
    public Map<String, String> getVariablesForContinuedBuild(@NotNull TriggerReason triggerReason) {
        HashMap<String, String> jiraVariables = new HashMap<String, String>();
        JIRAReleaseWmsTriggerReason jiraReleaseWmsTriggerReason = (JIRAReleaseWmsTriggerReason)((Object)Narrow.to((Object)triggerReason, JIRAReleaseWmsTriggerReason.class));
        if (jiraReleaseWmsTriggerReason != null) {
            jiraVariables.put("jira.baseUrl", jiraReleaseWmsTriggerReason.getJiraBaseUrl());
            jiraVariables.put("jira.projectKey", jiraReleaseWmsTriggerReason.getJiraProjectKey());
            jiraVariables.put("jira.projectName", jiraReleaseWmsTriggerReason.getJiraProjectName());
            jiraVariables.put(JIRA_VERSION_VARNAM, jiraReleaseWmsTriggerReason.getJiraVersionName());
            jiraVariables.put("jira.username", jiraReleaseWmsTriggerReason.getJiraUsername());
            jiraVariables.put(JIRA_ISSUES_VARNAM, this.jiraIssues == null || this.jiraIssues.isEmpty() ? jiraReleaseWmsTriggerReason.getJiraIssues() : this.jiraIssues);
        }
        return jiraVariables;
    }

    private List<String> doJiraRestCallOnAllAppLinks(@javax.annotation.Nullable String appLinkRequestURL, PlanTriggerResultBuilder resultBuilder) {
        JiraRestResponse jiraRestResponse = null;
        ArrayList<JiraRestResponse> jiraRestResponseList = new ArrayList<JiraRestResponse>();
        Iterable applicationLinkIterable = this.jiraApplinksService.getJiraApplicationLinks();
        if (((Collection)applicationLinkIterable).size() == 0) {
            resultBuilder.addErrorMessage("No Jira Application Links found. Please define one and try again.");
        }
        for (ApplicationLink applicationLink : applicationLinkIterable) {
            try {
                jiraRestResponse = this.jiraRestService.doRestCallViaApplink(applicationLink, appLinkRequestURL, Request.MethodType.GET, null);
            }
            catch (CredentialsRequiredContextException e) {
                resultBuilder.addErrorMessage("Credentials required for accessing Jira. Go to " + e.getAuthorisationURI() + " to get an authorization token");
            }
            if (jiraRestResponse == null || jiraRestResponse.hasErrors() || jiraRestResponse.statusCode != 200) continue;
            jiraRestResponseList.add(jiraRestResponse);
        }
        if (jiraRestResponseList.isEmpty()) {
            resultBuilder.addErrorMessage("No Jira issues found for this release. Cannot run build.");
        }
        ArrayList<String> jiraIssueKeys = new ArrayList<String>();
        for (JiraRestResponse jiraRR : jiraRestResponseList) {
            JSONObject jsonEntity = jiraRR.entity;
            try {
                JSONArray jiraIssueArray = jsonEntity.getJSONArray("issues");
                for (int i = 0; i < jiraIssueArray.length(); ++i) {
                    jiraIssueKeys.add(jiraIssueArray.getJSONObject(i).getString("key"));
                }
            }
            catch (JSONException e) {
                resultBuilder.addErrorMessage("No Jira Issues found for Jira Release");
            }
        }
        if (jiraIssueKeys.isEmpty()) {
            resultBuilder.addErrorMessage("No Jira Issues found for Jira Release");
        }
        return jiraIssueKeys;
    }
}

