/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.github.viewer;

import com.atlassian.bamboo.commit.CommitFile;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.viewer.runtime.VcsRepositoryViewer;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHubVcsRepositoryViewer
implements VcsRepositoryViewer {
    private static final Pattern GIT_AT_GITHUB_PATTERN = Pattern.compile("git@github.com:([^/]+/[^/]+)$");
    private static final Pattern GENERIC_GIT_PATTERN = Pattern.compile("[^/]+/[^/]+$");

    @Nullable
    public String getWebRepositoryUrlForRevision(@NotNull String revisionId, @NotNull VcsRepositoryData repositoryData) {
        return this.getRepositoryUrl(repositoryData) + "/commit/" + revisionId;
    }

    @NotNull
    public Map<String, String> getWebRepositoryUrlForRevisions(Stream<String> revisionIds, VcsRepositoryData repositoryDefinition) {
        return revisionIds.collect(Collectors.toMap(revId -> revId, revId -> this.getWebRepositoryUrlForRevision((String)revId, repositoryDefinition)));
    }

    @Nullable
    public String getWebRepositoryUrlForFile(@NotNull CommitFile file, @NotNull VcsRepositoryData repositoryData) {
        return this.getRepositoryUrl(repositoryData) + "/blob/" + this.getBranchName(repositoryData) + "/" + file.getName();
    }

    private String getBranchName(VcsRepositoryData repositoryData) {
        return (String)StringUtils.defaultIfBlank((CharSequence)repositoryData.getBranch().getVcsBranch().getName(), (CharSequence)"master");
    }

    @Nullable
    public String getWebRepositoryUrlForFileRevision(@NotNull CommitFile file, @NotNull VcsRepositoryData repositoryData) {
        if (!file.isRevisionKnown()) {
            return this.getWebRepositoryUrlForFile(file, repositoryData);
        }
        return this.getRepositoryUrl(repositoryData) + "/blob/" + file.getRevision() + "/" + file.getName();
    }

    @Nullable
    public String getWebRepositoryUrlForFileDiff(@NotNull CommitFile file, @NotNull VcsRepositoryData repositoryData) {
        return this.getRepositoryUrl(repositoryData) + "/commit/" + file.getRevision() + "#diff";
    }

    private String getRepositoryUrl(@NotNull VcsRepositoryData repositoryData) {
        Map cfg = repositoryData.getVcsLocation().getConfiguration();
        if ("com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:gitv2".equals(repositoryData.getPluginKey())) {
            return "https://github.com/" + GitHubVcsRepositoryViewer.getGitHubRepositoryNameFromGitUrl((String)cfg.get("repository.git.repositoryUrl"));
        }
        return cfg.getOrDefault("repository.github.baseUrl", "https://github.com/") + (String)cfg.get("repository.github.repository");
    }

    @VisibleForTesting
    @Nullable
    static String getGitHubRepositoryNameFromGitUrl(String repositoryUrl) {
        String noTrailingSlash = StringUtils.removeEnd((String)repositoryUrl, (String)"/");
        String noGit = StringUtils.removeEnd((String)noTrailingSlash, (String)".git");
        Matcher matcher1 = GIT_AT_GITHUB_PATTERN.matcher(noGit);
        if (matcher1.find()) {
            return matcher1.group(1);
        }
        Matcher matcher = GENERIC_GIT_PATTERN.matcher(noGit);
        return matcher.find() ? matcher.group(0) : null;
    }
}

