/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.github.exporter;

import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentialsIdentifier;
import com.atlassian.bamboo.specs.api.builders.repository.VcsChangeDetection;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.repository.VcsChangeDetectionProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.repository.git.SshPrivateKeyAuthentication;
import com.atlassian.bamboo.specs.builders.repository.git.UserPasswordAuthentication;
import com.atlassian.bamboo.specs.builders.repository.github.GitHubRepository;
import com.atlassian.bamboo.specs.model.repository.git.AuthenticationProperties;
import com.atlassian.bamboo.specs.model.repository.git.UserPasswordAuthenticationProperties;
import com.atlassian.bamboo.specs.model.repository.github.GitHubRepositoryProperties;
import com.atlassian.bamboo.specs.yaml.MapNode;
import com.atlassian.bamboo.specs.yaml.Node;
import com.atlassian.bamboo.specs.yaml.StringNode;
import com.atlassian.bamboo.specs.yaml.YamlSpecsValidationException;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.atlassian.bamboo.util.BambooConstantUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.UrlUtils;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsChangeDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.export.DefaultVcsRepositoryDataExporter;
import com.atlassian.bamboo.vcs.export.VcsRepositoryContext;
import com.atlassian.bamboo.vcs.export.VcsRepositoryDataExporter;
import com.atlassian.bamboo.vcs.export.YamlExportVcsRepositoryHelper;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHubConfigurationExporter
implements VcsRepositoryDataExporter<GitHubRepository, GitHubRepositoryProperties> {
    @NotNull
    public GitHubRepository getEntityPropertiesBuilder(@NotNull VcsRepositoryData repositoryData) {
        return new GitHubRepository();
    }

    @NotNull
    public GitHubRepository appendLocationData(@NotNull GitHubRepository builder, @NotNull VcsLocationDefinition vcsLocationDefinition, @NotNull VcsRepositoryContext repositoryContext) {
        Map configuration = vcsLocationDefinition.getConfiguration();
        int commandTimeout = configuration.containsKey("repository.github.commandTimeout") ? Integer.valueOf((String)configuration.get("repository.github.commandTimeout")) : 180;
        builder.repository((String)configuration.get("repository.github.repository")).shallowClonesEnabled(Boolean.valueOf((String)configuration.get("repository.github.useShallowClones")).booleanValue()).submodulesEnabled(Boolean.valueOf((String)configuration.get("repository.github.useSubmodules")).booleanValue()).sshKeyAppliesToSubmodules(Boolean.valueOf((String)configuration.get("repository.github.useSameKeyForSubmodules")).booleanValue()).remoteAgentCacheEnabled(Boolean.valueOf((String)configuration.get("repository.github.useRemoteAgentCache")).booleanValue()).commandTimeout(Duration.ofMinutes(commandTimeout)).verboseLogs(Boolean.valueOf((String)configuration.get("repository.github.verbose.logs")).booleanValue()).fetchWholeRepository(Boolean.valueOf((String)configuration.get("repository.github.fetch.whole.repository")).booleanValue()).lfsEnabled(Boolean.valueOf((String)configuration.get("repository.github.lfs")).booleanValue()).baseUrl(UrlUtils.stripTailingSlashes((String)configuration.getOrDefault("repository.github.baseUrl", "https://github.com")));
        String username = (String)configuration.get("repository.github.username");
        UserPasswordAuthentication userPasswordAuthentication = new UserPasswordAuthentication(username).password((String)configuration.get("repository.github.password"));
        builder.authentication(userPasswordAuthentication);
        return builder;
    }

    @NotNull
    public GitHubRepository appendBranchData(@NotNull GitHubRepository builder, @NotNull VcsBranchDefinition vcsBranchDefinition) {
        return builder.branch((String)vcsBranchDefinition.getConfiguration().get("repository.github.branch"));
    }

    @NotNull
    public GitHubRepository appendChangeDetectionOptions(@NotNull GitHubRepository builder, @NotNull VcsChangeDetectionOptions changeDetectionOptions) {
        builder.changeDetection(DefaultVcsRepositoryDataExporter.exportStandardChangeDetectionOptions((VcsChangeDetectionOptions)changeDetectionOptions));
        return builder;
    }

    @NotNull
    public GitHubRepository appendBranchDetectionOptions(@NotNull GitHubRepository builder, @NotNull VcsBranchDetectionOptions branchDetectionOptions) {
        return builder;
    }

    @Nullable
    public Map<String, String> importLocationData(@NotNull GitHubRepositoryProperties repositoryProperties, @Nullable VcsLocationDefinition existingData, @NotNull VcsRepositoryContext repositoryContext) {
        if (repositoryProperties.getRepository() != null) {
            HashMap<String, String> configuration = new HashMap<String, String>();
            configuration.put("repository.github.repository", repositoryProperties.getRepository());
            configuration.put("repository.github.useShallowClones", Boolean.toString(repositoryProperties.isUseShallowClones()));
            configuration.put("repository.github.useRemoteAgentCache", Boolean.toString(repositoryProperties.isUseRemoteAgentCache()));
            configuration.put("repository.github.useSubmodules", Boolean.toString(repositoryProperties.isUseSubmodules()));
            configuration.put("repository.github.useSameKeyForSubmodules", Boolean.toString(repositoryProperties.isSshKeyAppliesToSubmodules()));
            configuration.put("repository.github.commandTimeout", Long.toString(repositoryProperties.getCommandTimeout().toMinutes()));
            configuration.put("repository.github.verbose.logs", Boolean.toString(repositoryProperties.isVerboseLogs()));
            configuration.put("repository.github.fetch.whole.repository", Boolean.toString(repositoryProperties.isFetchWholeRepository()));
            configuration.put("repository.github.lfs", Boolean.toString(repositoryProperties.isUseLfs()));
            configuration.put("repository.github.baseUrl", UrlUtils.appendSlashIfDoesntExist((String)repositoryProperties.getBaseUrl()));
            AuthenticationProperties authenticationProperties = repositoryProperties.getAuthenticationProperties();
            if (authenticationProperties != null) {
                if (authenticationProperties instanceof UserPasswordAuthenticationProperties) {
                    UserPasswordAuthenticationProperties userPasswordAuthenticationProperties = (UserPasswordAuthenticationProperties)Narrow.to((Object)authenticationProperties, UserPasswordAuthenticationProperties.class);
                    configuration.put("repository.github.username", userPasswordAuthenticationProperties.getUsername());
                    configuration.put("repository.github.password", StringUtils.defaultString((String)userPasswordAuthenticationProperties.getPassword()));
                }
            } else {
                throw new PropertiesValidationException(new ValidationProblem("GitHub authentication data not defined"));
            }
            return configuration;
        }
        if (!repositoryProperties.hasParent()) {
            throw new PropertiesValidationException(Collections.singletonList(new ValidationProblem("GitHub server data not defined or incomplete")));
        }
        return null;
    }

    @Nullable
    public Map<String, String> importBranchData(@NotNull GitHubRepositoryProperties repositoryProperties, @Nullable VcsBranchDefinition existingData) {
        if (repositoryProperties.getBranch() != null) {
            HashMap<String, String> configuration = new HashMap<String, String>();
            configuration.put("repository.github.branch", repositoryProperties.getBranch());
            return configuration;
        }
        if (!repositoryProperties.hasParent()) {
            throw new PropertiesValidationException(Collections.singletonList(new ValidationProblem("GitHub branch not defined")));
        }
        return null;
    }

    @Nullable
    public Map<String, String> importChangeDetectionOptions(@NotNull GitHubRepositoryProperties repositoryProperties, @Nullable VcsChangeDetectionOptions existingData) {
        return DefaultVcsRepositoryDataExporter.importStandardChangeDetectionOptions((VcsRepositoryProperties)repositoryProperties, (VcsChangeDetectionProperties)repositoryProperties.getVcsChangeDetection());
    }

    @Nullable
    public Map<String, String> importBranchDetectionOptions(@NotNull GitHubRepositoryProperties repositoryProperties, @Nullable VcsBranchDetectionOptions existingData) {
        return null;
    }

    @Nullable
    public Node toYaml(@NotNull GitHubRepositoryProperties repo) throws PropertiesValidationException {
        LinkedHashMap<String, Object> structure = new LinkedHashMap<String, Object>();
        structure.put(YAML_TYPE, Config.GITHUB_TYPE);
        if (StringUtils.isNotBlank((CharSequence)repo.getDescription())) {
            structure.put(Config.DESCRIPTION, repo.getDescription());
        }
        if (StringUtils.isNotBlank((CharSequence)repo.getBaseUrl()) && !"https://github.com/".equals(repo.getBaseUrl())) {
            structure.put(Config.BASE_URL, repo.getBaseUrl());
        }
        structure.put(Config.REPOSITORY, repo.getRepository());
        if (StringUtils.isNotBlank((CharSequence)repo.getBranch())) {
            structure.put(Config.BRANCH, repo.getBranch());
        }
        if (repo.getAuthenticationProperties() != null) {
            YamlExportVcsRepositoryHelper.toYaml(structure, (AuthenticationProperties)repo.getAuthenticationProperties());
        }
        structure.put(Config.COMMAND_TIMEOUT, repo.getCommandTimeout().toMinutes());
        structure.put(Config.LFS, repo.isUseLfs());
        structure.put(Config.VERBOSE_LOGS, repo.isVerboseLogs());
        structure.put(Config.SHALLOW_CLONES, repo.isUseShallowClones());
        structure.put(Config.AGENT_CACHE, repo.isUseRemoteAgentCache());
        structure.put(Config.SUBMODULES, repo.isUseSubmodules());
        structure.put(Config.SSH_KEY_APPLIES_TO_SUBMODULES, repo.isSshKeyAppliesToSubmodules());
        structure.put(Config.FETCH_ALL_REPOSITORY, repo.isFetchWholeRepository());
        YamlExportVcsRepositoryHelper.toYaml(structure, (VcsChangeDetectionProperties)repo.getVcsChangeDetection());
        return new MapNode(structure, ValidationContext.of((String)StringUtils.defaultString((String)repo.getName(), (String)repo.getParentName())));
    }

    @Nullable
    public GitHubRepository fromYaml(@NotNull String name, final @NotNull Node node, @NotNull TaskValidationContext validationContext) throws YamlSpecsValidationException {
        if (node instanceof MapNode && Config.GITHUB_TYPE.equalsIgnoreCase(((MapNode)node).getOptionalString(YAML_TYPE).map(StringNode::get).orElse(""))) {
            MapNode config = (MapNode)node;
            final GitHubRepository result = new GitHubRepository();
            result.name(name);
            config.getOptionalString(Config.DESCRIPTION).ifPresent(val -> result.description(val.get()));
            config.getOptionalString(Config.BASE_URL).ifPresent(val -> result.baseUrl(val.get()));
            result.repository(config.getString(Config.REPOSITORY).get());
            result.branch(config.getOptionalString(Config.BRANCH).map(StringNode::get).orElse(""));
            YamlExportVcsRepositoryHelper.fromYaml((MapNode)config, (YamlExportVcsRepositoryHelper.AuthenticationVisitor)new YamlExportVcsRepositoryHelper.AuthenticationVisitor(){

                public void acceptUsernamePassword(UserPasswordAuthentication authentication) {
                    result.authentication(authentication);
                }

                public void acceptSshKey(SshPrivateKeyAuthentication authentication) {
                    throw new PropertiesValidationException(node.getValidationContext(), "SSH key is not supported for Github repository");
                }

                public void acceptSharedCredentials(SharedCredentialsIdentifier authentication) {
                    throw new PropertiesValidationException(node.getValidationContext(), "Shared credentials are not supported for Github repository");
                }
            });
            config.getOptionalString(Config.LFS).ifPresent(val -> result.lfsEnabled(Boolean.parseBoolean(val.get())));
            config.getOptionalString(Config.COMMAND_TIMEOUT).ifPresent(val -> result.commandTimeoutInMinutes(Integer.parseInt(val.get())));
            config.getOptionalString(Config.VERBOSE_LOGS).ifPresent(val -> result.verboseLogs(Boolean.parseBoolean(val.get())));
            config.getOptionalString(Config.SHALLOW_CLONES).ifPresent(val -> result.shallowClonesEnabled(Boolean.parseBoolean(val.get())));
            config.getOptionalString(Config.AGENT_CACHE).ifPresent(val -> result.remoteAgentCacheEnabled(Boolean.parseBoolean(val.get())));
            config.getOptionalString(Config.SUBMODULES).ifPresent(val -> result.submodulesEnabled(Boolean.parseBoolean(val.get())));
            config.getOptionalString(Config.SSH_KEY_APPLIES_TO_SUBMODULES).ifPresent(val -> result.sshKeyAppliesToSubmodules(Boolean.parseBoolean(val.get())));
            config.getOptionalString(Config.FETCH_ALL_REPOSITORY).ifPresent(val -> result.fetchWholeRepository(Boolean.parseBoolean(val.get())));
            VcsChangeDetection changeDetection = YamlExportVcsRepositoryHelper.changeDetectionFromYaml((MapNode)config);
            if (changeDetection != null) {
                result.changeDetection(changeDetection);
            }
            return result;
        }
        return null;
    }

    private static interface Config {
        public static final String GITHUB_TYPE = (String)BambooConstantUtils.preventInlining((Object)"github");
        public static final String DESCRIPTION = (String)BambooConstantUtils.preventInlining((Object)"description");
        public static final String REPOSITORY = (String)BambooConstantUtils.preventInlining((Object)"repository");
        public static final String BRANCH = (String)BambooConstantUtils.preventInlining((Object)"branch");
        public static final String BASE_URL = (String)BambooConstantUtils.preventInlining((Object)"base-url");
        public static final String COMMAND_TIMEOUT = (String)BambooConstantUtils.preventInlining((Object)"command-timeout-minutes");
        public static final String LFS = (String)BambooConstantUtils.preventInlining((Object)"lfs");
        public static final String VERBOSE_LOGS = (String)BambooConstantUtils.preventInlining((Object)"verbose-logs");
        public static final String SHALLOW_CLONES = (String)BambooConstantUtils.preventInlining((Object)"use-shallow-clones");
        public static final String AGENT_CACHE = (String)BambooConstantUtils.preventInlining((Object)"cache-on-agents");
        public static final String SUBMODULES = (String)BambooConstantUtils.preventInlining((Object)"submodules");
        public static final String SSH_KEY_APPLIES_TO_SUBMODULES = (String)BambooConstantUtils.preventInlining((Object)"ssh-key-applies-to-submodules");
        public static final String FETCH_ALL_REPOSITORY = (String)BambooConstantUtils.preventInlining((Object)"fetch-all");
    }
}

