/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.github.configurator;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.plugins.github.configurator.GitHubConfigurationConstants;
import com.atlassian.bamboo.utils.BambooFieldValidate;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinition;
import com.atlassian.bamboo.vcs.configurator.VcsBranchConfigurator;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHubBranchConfigurator
implements VcsBranchConfigurator {
    private static final Logger log = Logger.getLogger(GitHubBranchConfigurator.class);
    private final I18nResolver i18nResolver;
    private final CustomVariableContext customVariableContext;

    @Inject
    public GitHubBranchConfigurator(I18nResolver i18nResolver, CustomVariableContext customVariableContext) {
        this.i18nResolver = i18nResolver;
        this.customVariableContext = customVariableContext;
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull VcsBranchDefinition branchDefinition) {
        this.populateContextCommon(context, branchDefinition);
    }

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull VcsBranchDefinition branchDefinition) {
        this.populateContextCommon(context, branchDefinition);
    }

    private void populateContextCommon(@NotNull Map<String, Object> context, @NotNull VcsBranchDefinition vcsLocationDefinition) {
        Map cfg = vcsLocationDefinition.getConfiguration();
        context.put("repository.github.branch", cfg.get("repository.github.branch"));
    }

    public void validate(@NotNull ActionParametersMap actionParametersMap, @NotNull ErrorCollection errorCollection) {
        if (BambooFieldValidate.findFieldShellInjectionViolation((ErrorCollection)errorCollection, (I18nResolver)this.i18nResolver, (String)"repository.github.branch", (String)this.substituteString(actionParametersMap.getString("repository.github.branch")))) {
            return;
        }
    }

    private String substituteString(@Nullable String stringWithValuesToSubstitute) {
        return this.customVariableContext.substituteString(stringWithValuesToSubstitute);
    }

    @NotNull
    public VcsBranch getVcsBranchFromConfig(@NotNull Map<String, String> configMap) {
        return new VcsBranchImpl((String)StringUtils.defaultIfBlank((CharSequence)configMap.get("repository.github.branch"), (CharSequence)"master"));
    }

    @NotNull
    public Map<String, String> setVcsBranchInConfig(@NotNull Map<String, String> configMap, @NotNull VcsBranch vcsBranch) {
        configMap.put("repository.github.branch", vcsBranch.getName());
        return configMap;
    }

    @NotNull
    public VcsBranch createVcsBranchFromName(@NotNull String name) {
        return new VcsBranchImpl(name);
    }

    @NotNull
    public VcsBranch createVcsBranchFromNameForForkWorkflow(@NotNull String branchName, @NotNull String pullRequestKey) {
        return this.createVcsBranchFromName((String)GitHubConfigurationConstants.pullRequestRef.apply(pullRequestKey));
    }

    @NotNull
    public Map<String, String> generateConfigMap(@NotNull ActionParametersMap actionParametersMap, @Nullable VcsBranchDefinition previousBranchDefinition, @NotNull Map<String, String> locationConfiguration) {
        HashMap<String, String> cfgMap = new HashMap<String, String>();
        cfgMap.put("repository.github.branch", actionParametersMap.getString("repository.github.branch"));
        return cfgMap;
    }
}

