/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.github;

import com.atlassian.bamboo.plan.pullrequest.VcsPullRequest;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequestImpl;
import com.atlassian.bamboo.plugins.git.GitHubAccessor;
import com.atlassian.bamboo.plugins.github.GitHubRepositoryHelper;
import com.atlassian.bamboo.plugins.github.dto.GithubPullRequestDto;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.runtime.ContextualVcsId;
import com.atlassian.bamboo.vcs.runtime.IdentifyingExecutor;
import com.atlassian.bamboo.vcs.runtime.VcsPullRequestDetector;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class GithubPullRequestDetector
implements VcsPullRequestDetector {
    private static final Logger log = Logger.getLogger(GithubPullRequestDetector.class);

    @Nullable
    public ContextualVcsId<VcsPullRequestDetector> getVcsIdForExecutor(@NotNull VcsRepositoryData vcsRepositoryData) {
        return new ContextualVcsId((IdentifyingExecutor)this, vcsRepositoryData, new String[]{(String)vcsRepositoryData.getVcsLocation().getConfiguration().get("repository.github.repository")});
    }

    @NotNull
    public List<VcsPullRequest> getOpenPullRequests(@NotNull VcsRepositoryData repositoryData) throws RepositoryException {
        log.info((Object)("Fetch list of Github PRs [repositoryId: " + repositoryData.getId() + "]"));
        Pair<String, String> userNameAndPassword = GitHubRepositoryHelper.getRepositoryUsernameAndPassword(repositoryData);
        if (userNameAndPassword == null) {
            log.error((Object)("Can't find credentials for repository:" + repositoryData.getName() + " (id=" + repositoryData.getId() + ")"));
            return Collections.emptyList();
        }
        String baseUrl = (String)repositoryData.getVcsLocation().getConfiguration().get("repository.github.baseUrl");
        GitHubAccessor gitHubAccessor = new GitHubAccessor((String)userNameAndPassword.getFirst(), (String)userNameAndPassword.getSecond(), GitHubAccessor.transformBaseUrlToApiUrl(baseUrl));
        return this.getPullRequestsByRepository(repositoryData, gitHubAccessor).stream().map(pr -> this.convert(repositoryData, (GithubPullRequestDto)pr)).collect(Collectors.toList());
    }

    @VisibleForTesting
    protected List<GithubPullRequestDto> getPullRequestsByRepository(@NotNull VcsRepositoryData repositoryData, @NotNull GitHubAccessor gitHubAccessor) throws RepositoryException {
        try {
            return gitHubAccessor.getPullRequests(repositoryData);
        }
        catch (GitHubAccessor.GitHubException | IOException e) {
            throw new RepositoryException((Throwable)e, repositoryData.getRootVcsRepositoryId());
        }
    }

    @NotNull
    private VcsPullRequest convert(@NotNull VcsRepositoryData repositoryData, GithubPullRequestDto pr) {
        VcsPullRequestImpl request = new VcsPullRequestImpl();
        request.setKey(pr.id);
        if (this.isFork(pr)) {
            request.setSourceRepositoryId(null);
            request.setVcsForkDto(pr.source.owner, pr.source.repository);
        } else {
            request.setSourceRepositoryId(Long.valueOf(repositoryData.getRootVcsRepositoryId()));
        }
        request.setSource(pr.source.branch);
        request.setTargetRepositoryId(repositoryData.getRootVcsRepositoryId());
        request.setTarget(pr.target.branch);
        request.setOpen(true);
        return request;
    }

    private boolean isFork(GithubPullRequestDto pr) {
        return pr.source.repositoryId != pr.target.repositoryId;
    }

    public boolean supportsForkedPullRequests() {
        return true;
    }
}

