/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.github;

import com.atlassian.bamboo.plugins.git.GitHubRepository;
import com.atlassian.bamboo.repository.CachedRepositoryDefinitionManager;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryDataImpl;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class GitHubRepositoryHelper {
    @Nullable
    public static Pair<String, String> getRepositoryUsernameAndPassword(long repositoryId, CachedRepositoryDefinitionManager cachedRepositoryDefinitionManager) {
        VcsRepositoryData vcsRepositoryData = cachedRepositoryDefinitionManager.getVcsRepositoryData(repositoryId);
        return GitHubRepositoryHelper.getRepositoryUsernameAndPassword(vcsRepositoryData);
    }

    @Nullable
    public static Pair<String, String> getRepositoryUsernameAndPassword(VcsRepositoryData vcsRepositoryData) {
        if (vcsRepositoryData == null) {
            return null;
        }
        if (vcsRepositoryData.isLegacyRepository()) {
            RepositoryDataImpl repositoryData = new RepositoryDataImpl(vcsRepositoryData);
            Repository repository = repositoryData.getRepository();
            GitHubRepository ghRepository = (GitHubRepository)Narrow.to((Object)repository, GitHubRepository.class);
            if (ghRepository != null) {
                return Pair.make((Object)ghRepository.getUsername(), (Object)ghRepository.getPassword());
            }
        } else {
            return Pair.make((Object)((String)vcsRepositoryData.getVcsLocation().getConfiguration().get("repository.github.username")), (Object)((String)vcsRepositoryData.getVcsLocation().getConfiguration().get("repository.github.password")));
        }
        return null;
    }

    @Nullable
    public static String getRepositoryOwner(VcsRepositoryData repositoryData) {
        if (repositoryData.isLegacyRepository()) {
            return ((GitHubRepository)repositoryData.asLegacyData().getRepository()).getUsername();
        }
        Map config = repositoryData.getVcsLocation().getConfiguration();
        return (String)config.get("repository.github.username");
    }

    public static String getRepositorySlug(VcsRepositoryData repositoryData) {
        if (repositoryData.isLegacyRepository()) {
            return ((GitHubRepository)repositoryData.asLegacyData().getRepository()).getRepository();
        }
        String repository = (String)repositoryData.getVcsLocation().getConfiguration().get("repository.github.repository");
        return GitHubRepositoryHelper.checkSplitRepositoryName(repository)[1];
    }

    private static String[] checkSplitRepositoryName(String repository) {
        String[] ownerSlugPair = repository.split("/");
        Preconditions.checkArgument((ownerSlugPair.length == 2 ? 1 : 0) != 0, (String)"repository has an incorrect value [%s]", (Object)repository);
        return ownerSlugPair;
    }
}

