/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.v2.configurator;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitPasswordCredentialsSource;
import com.atlassian.bamboo.plugins.git.GitSshCredentialsSource;
import com.atlassian.bamboo.repository.NameValuePair;
import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentialsScope;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.utils.BambooFieldValidate;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinition;
import com.atlassian.bamboo.vcs.configurator.VcsLocationConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsType;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitServerConfigurator
implements VcsLocationConfigurator {
    private static final Logger log = Logger.getLogger(GitServerConfigurator.class);
    private final I18nResolver i18nResolver;
    private final CustomVariableContext customVariableContext;
    private final CredentialsAccessor credentialsAccessor;
    private final SecretEncryptionService secretEncryptionService;

    @Inject
    public GitServerConfigurator(@BambooImport I18nResolver i18nResolver, @BambooImport CustomVariableContext customVariableContext, @BambooImport CredentialsAccessor credentialsAccessor, @BambooImport SecretEncryptionService secretEncryptionService) {
        this.i18nResolver = i18nResolver;
        this.customVariableContext = customVariableContext;
        this.credentialsAccessor = credentialsAccessor;
        this.secretEncryptionService = secretEncryptionService;
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        context.put("repository.git.commandTimeout", 180);
        context.put("repository.git.useRemoteAgentCache", true);
        context.put("repository.git.authenticationType", GitAuthenticationType.NONE.name());
        context.put("repository.git.sshCredentialsSource", this.getDefaultSshCredentialsSource().name());
        context.put("repository.git.passwordCredentialsSource", this.getDefaultPasswordCredentialsSource().name());
        context.put("repository.git.useSameKeyForSubmodules", Boolean.TRUE.toString());
        this.populateSelectListItems(context);
    }

    private String getAuthTypeName(String authType) {
        return this.i18nResolver.getText("repository.git.authenticationType." + StringUtils.lowerCase((String)authType));
    }

    private String getSshCredentialsSourceName(String source) {
        return this.i18nResolver.getText("repository.git.sshCredentialsSource." + StringUtils.lowerCase((String)source));
    }

    private String getPasswordCredentialsSourceName(String source) {
        return this.i18nResolver.getText("repository.git.passwordCredentialsSource." + StringUtils.lowerCase((String)source));
    }

    private GitSshCredentialsSource getDefaultSshCredentialsSource() {
        return this.credentialsAccessor.hasAnyCredentials("com.atlassian.bamboo.plugin.sharedCredentials:sshCredentials") ? GitSshCredentialsSource.SHARED_CREDENTIALS : GitSshCredentialsSource.CUSTOM;
    }

    private GitPasswordCredentialsSource getDefaultPasswordCredentialsSource() {
        return this.credentialsAccessor.hasAnyCredentials("com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials") ? GitPasswordCredentialsSource.SHARED_CREDENTIALS : GitPasswordCredentialsSource.CUSTOM;
    }

    @NotNull
    private List<NameValuePair> getSharedCredentials(String pluginKey) {
        return BambooIterables.stream((Iterable)this.credentialsAccessor.getAllCredentials(pluginKey)).map(credentials -> new NameValuePair(Long.toString(credentials.getId()), credentials.getName(), "global")).collect(Collectors.toList());
    }

    @NotNull
    private List<NameValuePair> getProjectSharedCredentials(Long projectId, String pluginKey) {
        return BambooIterables.stream((Iterable)this.credentialsAccessor.getProjectCredentialsByPluginKey(projectId, pluginKey)).map(credentials -> new NameValuePair(Long.toString(credentials.getId()), credentials.getName(), "project")).collect(Collectors.toList());
    }

    private List<NameValuePair> getGitAuthenticationTypes() {
        return Arrays.stream(GitAuthenticationType.values()).map(Enum::name).map(name -> new NameValuePair(name, this.getAuthTypeName((String)name))).collect(Collectors.toList());
    }

    public List<NameValuePair> getSshCredentialsSources() {
        return Arrays.stream(GitSshCredentialsSource.values()).map(Enum::name).map(name -> new NameValuePair(name, this.getSshCredentialsSourceName((String)name))).collect(Collectors.toList());
    }

    private List<NameValuePair> getPasswordCredentialsSources() {
        return Arrays.stream(GitPasswordCredentialsSource.values()).map(Enum::name).map(name -> new NameValuePair(name, this.getPasswordCredentialsSourceName((String)name))).collect(Collectors.toList());
    }

    private void populateSelectListItems(@NotNull Map<String, Object> context) {
        context.put("gitAuthenticationTypes", this.getGitAuthenticationTypes());
        context.put("sshCredentialsSources", this.getSshCredentialsSources());
        context.put("passwordCredentialsSources", this.getPasswordCredentialsSources());
        if (context.containsKey("projectId")) {
            context.put("passwordSharedCredentials", Stream.concat(this.getProjectSharedCredentials((Long)context.get("projectId"), "com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials").stream(), this.getSharedCredentials("com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials").stream()).collect(Collectors.toList()));
            context.put("sshSharedCredentials", Stream.concat(this.getProjectSharedCredentials((Long)context.get("projectId"), "com.atlassian.bamboo.plugin.sharedCredentials:sshCredentials").stream(), this.getSharedCredentials("com.atlassian.bamboo.plugin.sharedCredentials:sshCredentials").stream()).collect(Collectors.toList()));
        } else {
            context.put("passwordSharedCredentials", this.getSharedCredentials("com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials"));
            context.put("sshSharedCredentials", this.getSharedCredentials("com.atlassian.bamboo.plugin.sharedCredentials:sshCredentials"));
        }
    }

    private void populateContextCommon(@NotNull Map<String, Object> context, @NotNull VcsLocationDefinition vcsLocationDefinition) {
        block14: {
            Map cfg = vcsLocationDefinition.getConfiguration();
            context.put("repository.git.repositoryUrl", cfg.get("repository.git.repositoryUrl"));
            context.put("repository.git.useShallowClones", Boolean.parseBoolean((String)cfg.get("repository.git.useShallowClones")));
            context.put("repository.git.useRemoteAgentCache", cfg.get("repository.git.useRemoteAgentCache"));
            context.put("repository.git.useSubmodules", cfg.get("repository.git.useSubmodules"));
            context.put("repository.git.useSameKeyForSubmodules", cfg.get("repository.git.useSameKeyForSubmodules"));
            context.put("repository.git.commandTimeout", cfg.get("repository.git.commandTimeout"));
            context.put("repository.git.verbose.logs", cfg.get("repository.git.verbose.logs"));
            context.put("repository.git.fetch.whole.repository", Boolean.parseBoolean((String)cfg.get("repository.git.fetch.whole.repository")));
            context.put("repository.git.lfs", Boolean.parseBoolean((String)cfg.get("repository.git.lfs")));
            String authenticationTypeString = (String)cfg.get("repository.git.authenticationType");
            context.put("repository.git.authenticationType", authenticationTypeString);
            GitAuthenticationType authenticationType = GitAuthenticationType.valueOf(authenticationTypeString);
            block0 : switch (authenticationType) {
                case NONE: {
                    context.put("repository.git.sshCredentialsSource", this.getDefaultSshCredentialsSource().name());
                    context.put("repository.git.passwordCredentialsSource", this.getDefaultPasswordCredentialsSource().name());
                    break;
                }
                case PASSWORD: {
                    String passwordCredentialsSourceString = (String)cfg.get("repository.git.passwordCredentialsSource");
                    context.put("repository.git.passwordCredentialsSource", passwordCredentialsSourceString);
                    context.put("repository.git.sshCredentialsSource", this.getDefaultSshCredentialsSource().name());
                    switch (GitPasswordCredentialsSource.valueOf(passwordCredentialsSourceString)) {
                        case SHARED_CREDENTIALS: {
                            String passwordSharedCredentialsId = (String)cfg.get("repository.git.passwordSharedCredentials");
                            context.put("repository.git.passwordSharedCredentials", passwordSharedCredentialsId);
                            if (this.credentialExists(Long.parseLong(passwordSharedCredentialsId))) break;
                            context.put("repository.git.sharedCredentials.deleted", true);
                            break;
                        }
                        case CUSTOM: {
                            context.put("repository.git.passwordCredentialsSource", GitPasswordCredentialsSource.CUSTOM.name());
                            context.put("repository.git.username", cfg.get("repository.git.username"));
                            this.putDummyIfValueIsNotBlank(context, cfg, "repository.git.password");
                        }
                    }
                    break;
                }
                case SSH_KEYPAIR: {
                    String sshCredentialsSourceString = (String)cfg.get("repository.git.sshCredentialsSource");
                    context.put("repository.git.sshCredentialsSource", sshCredentialsSourceString);
                    context.put("repository.git.passwordCredentialsSource", this.getDefaultPasswordCredentialsSource().name());
                    switch (GitSshCredentialsSource.valueOf(sshCredentialsSourceString)) {
                        case SHARED_CREDENTIALS: {
                            String sshSharedCredentialsId = (String)cfg.get("repository.git.sharedCredentials");
                            context.put("repository.git.sharedCredentials", sshSharedCredentialsId);
                            if (!this.credentialExists(Long.parseLong(sshSharedCredentialsId))) {
                                context.put("repository.git.sharedCredentials.deleted", true);
                                break block0;
                            }
                            break block14;
                        }
                        case CUSTOM: {
                            this.putDummyIfValueIsNotBlank(context, cfg, "repository.git.ssh.key");
                            this.putDummyIfValueIsNotBlank(context, cfg, "repository.git.ssh.passphrase");
                        }
                    }
                }
            }
        }
    }

    private void putDummyIfValueIsNotBlank(@NotNull Map<String, Object> context, @NotNull Map<String, String> cfg, String key) {
        if (StringUtils.isNotBlank((CharSequence)cfg.get(key))) {
            context.put(key, "dummy");
        }
    }

    @NotNull
    public Iterable<Long> getSharedCredentialsIds(@NotNull VcsLocationDefinition vcsLocationDefinition) {
        ArrayList<Long> result = new ArrayList<Long>();
        String sharedCredentialsId = (String)vcsLocationDefinition.getConfiguration().get("repository.git.sharedCredentials");
        if (sharedCredentialsId == null) {
            sharedCredentialsId = (String)vcsLocationDefinition.getConfiguration().get("repository.git.passwordSharedCredentials");
        }
        if (sharedCredentialsId != null) {
            result.add(Long.parseLong(sharedCredentialsId));
        }
        return result;
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull VcsLocationDefinition vcsLocationDefinition) {
        this.populateContextCommon(context, vcsLocationDefinition);
        this.populateSelectListItems(context);
    }

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull VcsLocationDefinition vcsLocationDefinition) {
        this.populateContextCommon(context, vcsLocationDefinition);
        this.populateSelectListItems(context);
    }

    private GitAuthenticationType getGitAuthenticationType(ActionParametersMap actionParametersMap) {
        String authTypeString = actionParametersMap.getString("repository.git.authenticationType");
        if (!StringUtils.isBlank((CharSequence)authTypeString)) {
            return GitAuthenticationType.valueOf(authTypeString);
        }
        return GitAuthenticationType.NONE;
    }

    private String substituteString(@Nullable String stringWithValuesToSubstitute) {
        return this.customVariableContext.substituteString(stringWithValuesToSubstitute);
    }

    public void validate(@NotNull ActionParametersMap actionParametersMap, @Nullable VcsLocationDefinition previousDefinition, @NotNull ErrorCollection errorCollection) {
        Map<String, String> cfgMap;
        block24: {
            cfgMap = this.generateConfigMap(actionParametersMap, previousDefinition);
            String repositoryUrl = StringUtils.trim((String)cfgMap.get("repository.git.repositoryUrl"));
            GitAuthenticationType authenticationType = this.getGitAuthenticationType(actionParametersMap);
            if (BambooFieldValidate.findFieldShellInjectionViolation((ErrorCollection)errorCollection, (I18nResolver)this.i18nResolver, (String)"repository.git.repositoryUrl", (String)this.substituteString(cfgMap.get("repository.git.repositoryUrl")))) {
                return;
            }
            if (BambooFieldValidate.findFieldShellInjectionViolation((ErrorCollection)errorCollection, (I18nResolver)this.i18nResolver, (String)"repository.git.username", (String)this.substituteString(cfgMap.get("repository.git.username")))) {
                return;
            }
            if (cfgMap.get("repository.git.commandTimeout") != null) {
                if (NumberUtils.isCreatable((String)cfgMap.get("repository.git.commandTimeout"))) {
                    int tmpCommandTimout = Integer.parseInt(cfgMap.get("repository.git.commandTimeout"));
                    if (tmpCommandTimout <= 0) {
                        errorCollection.addError("repository.git.commandTimeout", this.i18nResolver.getText("repository.git.messages.commandTimeout.positive"));
                    }
                } else {
                    errorCollection.addError("repository.git.commandTimeout", this.i18nResolver.getText("repository.git.messages.commandTimeout.numerical"));
                }
            }
            if (StringUtils.isBlank((CharSequence)repositoryUrl)) {
                errorCollection.addError("repository.git.repositoryUrl", this.i18nResolver.getText("repository.git.messages.missingRepositoryUrl"));
            } else {
                GitPasswordCredentialsSource passwordCredentialsSource = authenticationType == GitAuthenticationType.PASSWORD ? GitPasswordCredentialsSource.valueOf(cfgMap.get("repository.git.passwordCredentialsSource")) : null;
                boolean hasUsername = passwordCredentialsSource == GitPasswordCredentialsSource.SHARED_CREDENTIALS || StringUtils.isNotBlank((CharSequence)cfgMap.get("repository.git.username"));
                boolean hasPassword = passwordCredentialsSource == GitPasswordCredentialsSource.SHARED_CREDENTIALS || StringUtils.isNotBlank((CharSequence)cfgMap.get("repository.git.password"));
                try {
                    URIish uri = new URIish(repositoryUrl);
                    if (authenticationType == GitAuthenticationType.SSH_KEYPAIR) {
                        String passphrase;
                        GitSshCredentialsSource sshCredentialsSource;
                        if ("http".equals(uri.getScheme()) || "https".equals(uri.getScheme())) {
                            errorCollection.addError("repository.git.authenticationType", this.i18nResolver.getText("repository.git.messages.unsupportedHttpAuthenticationType"));
                        }
                        if ((sshCredentialsSource = GitSshCredentialsSource.valueOf(cfgMap.get("repository.git.sshCredentialsSource"))) == GitSshCredentialsSource.SHARED_CREDENTIALS && !cfgMap.containsKey("repository.git.sharedCredentials")) {
                            errorCollection.addError("repository.git.authenticationType", this.i18nResolver.getText("repository.git.messages.sharedCredentialEmpty"));
                        }
                        if (StringUtils.isNotEmpty((CharSequence)(passphrase = cfgMap.get("repository.git.ssh.passphrase"))) && this.secretEncryptionService.isEncrypted(passphrase) && !this.secretEncryptionService.isDecryptable(passphrase)) {
                            errorCollection.addError("temporary.git.ssh.passphrase", this.i18nResolver.getText("global.error.secret.not.decryptable"));
                        }
                    } else if (authenticationType == GitAuthenticationType.PASSWORD) {
                        if (passwordCredentialsSource == GitPasswordCredentialsSource.SHARED_CREDENTIALS && !cfgMap.containsKey("repository.git.passwordSharedCredentials")) {
                            errorCollection.addError("repository.git.authenticationType", this.i18nResolver.getText("repository.git.messages.sharedCredentialEmpty"));
                        } else {
                            String password;
                            String errorField;
                            boolean duplicatePassword;
                            boolean duplicateUsername = hasUsername && StringUtils.isNotBlank((CharSequence)uri.getUser());
                            boolean bl = duplicatePassword = hasPassword && StringUtils.isNotBlank((CharSequence)uri.getPass());
                            if (duplicateUsername || duplicatePassword) {
                                errorCollection.addError("repository.git.repositoryUrl", (duplicateUsername ? this.i18nResolver.getText("repository.git.messages.duplicateUsernameField") : "") + (duplicateUsername && duplicatePassword ? " " : "") + (duplicatePassword ? this.i18nResolver.getText("repository.git.messages.duplicatePasswordField") : ""));
                            }
                            if (duplicateUsername) {
                                errorField = passwordCredentialsSource == GitPasswordCredentialsSource.SHARED_CREDENTIALS ? "repository.git.passwordSharedCredentials" : "repository.git.username";
                                errorCollection.addError(errorField, this.i18nResolver.getText("repository.git.messages.duplicateUsernameField"));
                            }
                            if (duplicatePassword) {
                                errorField = passwordCredentialsSource == GitPasswordCredentialsSource.SHARED_CREDENTIALS ? "repository.git.passwordSharedCredentials" : "temporary.git.password.change";
                                errorCollection.addError(errorField, this.i18nResolver.getText("repository.git.messages.duplicatePasswordField"));
                            }
                            if (uri.getHost() == null && hasUsername) {
                                errorCollection.addError("repository.git.authenticationType", this.i18nResolver.getText("repository.git.messages.unsupportedUsernameField"));
                            }
                            if (StringUtils.isNotBlank((CharSequence)cfgMap.get("repository.git.password")) && this.secretEncryptionService.isEncrypted(password = cfgMap.get("repository.git.password")) && !this.secretEncryptionService.isDecryptable(password)) {
                                errorCollection.addError("temporary.git.password", this.i18nResolver.getText("global.error.secret.not.decryptable"));
                            }
                        }
                    }
                }
                catch (URISyntaxException e) {
                    if (!hasUsername) break block24;
                    String fieldForError = "repository.git.authenticationType";
                    errorCollection.addError("repository.git.authenticationType", this.i18nResolver.getText("repository.git.messages.unsupportedUsernameField"));
                }
            }
        }
        String key = cfgMap.get("repository.git.ssh.key");
        if (!StringUtils.isBlank((CharSequence)key) && !key.contains("-----BEGIN")) {
            errorCollection.addError("temporary.git.ssh.key.change", this.i18nResolver.getText("repository.git.messages.invalidSshKeys"));
        }
    }

    @NotNull
    public void validateForConnectionTesting(@NotNull ActionParametersMap actionParametersMap, @Nullable VcsLocationDefinition previousDefinition, @NotNull ErrorCollection errorCollection) {
        boolean changingSshKey;
        GitAuthenticationType authenticationType = this.getGitAuthenticationType(actionParametersMap);
        boolean usingSshAuth = GitAuthenticationType.SSH_KEYPAIR == authenticationType;
        boolean usingCustomSshKey = usingSshAuth && GitSshCredentialsSource.CUSTOM.name().equals(actionParametersMap.getString("repository.git.sshCredentialsSource"));
        boolean bl = changingSshKey = usingCustomSshKey && actionParametersMap.getBoolean("temporary.git.ssh.key.change");
        if (changingSshKey) {
            errorCollection.addError("temporary.git.ssh.keyfile", this.i18nResolver.getText("repository.test.connection.private.key.not.received"));
        } else {
            this.validate(actionParametersMap, previousDefinition, errorCollection);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public Map<String, String> generateConfigMap(@NotNull ActionParametersMap actionParametersMap, @Nullable VcsLocationDefinition previousVcsLocationDefinition) {
        HashMap<String, String> cfgMap;
        block23: {
            cfgMap = new HashMap<String, String>();
            if (previousVcsLocationDefinition != null) {
                cfgMap.putAll(previousVcsLocationDefinition.getConfiguration());
            }
            cfgMap.put("repository.git.repositoryUrl", actionParametersMap.getString("repository.git.repositoryUrl"));
            cfgMap.put("repository.git.useShallowClones", Boolean.toString(actionParametersMap.getBoolean("repository.git.useShallowClones")));
            cfgMap.put("repository.git.useRemoteAgentCache", Boolean.toString(actionParametersMap.getBoolean("repository.git.useRemoteAgentCache")));
            cfgMap.put("repository.git.useSubmodules", Boolean.toString(actionParametersMap.getBoolean("repository.git.useSubmodules")));
            cfgMap.put("repository.git.useSameKeyForSubmodules", Boolean.toString(actionParametersMap.getBoolean("repository.git.useSameKeyForSubmodules")));
            cfgMap.put("repository.git.commandTimeout", actionParametersMap.getString("repository.git.commandTimeout"));
            cfgMap.put("repository.git.verbose.logs", Boolean.toString(actionParametersMap.getBoolean("repository.git.verbose.logs")));
            cfgMap.put("repository.git.fetch.whole.repository", Boolean.toString(actionParametersMap.getBoolean("repository.git.fetch.whole.repository")));
            cfgMap.put("repository.git.lfs", Boolean.toString(actionParametersMap.getBoolean("repository.git.lfs")));
            String chosenAuthentication = actionParametersMap.getString("repository.git.authenticationType", GitAuthenticationType.NONE.name());
            cfgMap.put("repository.git.authenticationType", chosenAuthentication);
            switch (GitAuthenticationType.valueOf(chosenAuthentication)) {
                case NONE: {
                    cfgMap.remove("repository.git.username");
                    cfgMap.remove("repository.git.password");
                    cfgMap.remove("repository.git.ssh.key");
                    cfgMap.remove("repository.git.ssh.passphrase");
                    cfgMap.remove("repository.git.passwordCredentialsSource");
                    cfgMap.remove("repository.git.passwordSharedCredentials");
                    cfgMap.remove("repository.git.passwordSharedCredentials.scope");
                    cfgMap.remove("repository.git.sshCredentialsSource");
                    cfgMap.remove("repository.git.sharedCredentials");
                    cfgMap.remove("repository.git.sharedCredentials.scope");
                    return cfgMap;
                }
                case PASSWORD: {
                    cfgMap.remove("repository.git.ssh.key");
                    cfgMap.remove("repository.git.ssh.passphrase");
                    cfgMap.remove("repository.git.sshCredentialsSource");
                    cfgMap.remove("repository.git.sharedCredentials");
                    cfgMap.remove("repository.git.sharedCredentials.scope");
                    String passwordCredentialsSourceString = actionParametersMap.getString("repository.git.passwordCredentialsSource");
                    cfgMap.put("repository.git.passwordCredentialsSource", passwordCredentialsSourceString);
                    switch (GitPasswordCredentialsSource.valueOf(passwordCredentialsSourceString)) {
                        case SHARED_CREDENTIALS: {
                            cfgMap.remove("repository.git.username");
                            cfgMap.remove("repository.git.password");
                            String passwordSharedCredentialsId = actionParametersMap.getString("repository.git.passwordSharedCredentials");
                            if (passwordSharedCredentialsId == null) break;
                            CredentialsData credentials = this.credentialsAccessor.getCredentials(Long.parseLong(passwordSharedCredentialsId));
                            if (credentials != null && credentials.getProjectId() != null) {
                                cfgMap.put("repository.git.passwordSharedCredentials.scope", SharedCredentialsScope.PROJECT.name());
                            }
                            cfgMap.put("repository.git.sharedCredentials.deleted", Boolean.toString(credentials == null));
                            cfgMap.put("repository.git.passwordSharedCredentials", passwordSharedCredentialsId);
                            return cfgMap;
                        }
                        case CUSTOM: {
                            cfgMap.remove("repository.git.passwordSharedCredentials");
                            cfgMap.remove("repository.git.passwordSharedCredentials.scope");
                            cfgMap.put("repository.git.username", actionParametersMap.getString("repository.git.username"));
                            if (!actionParametersMap.getBoolean("temporary.git.password.change")) break;
                            cfgMap.put("repository.git.password", actionParametersMap.getString("temporary.git.password"));
                        }
                    }
                    return cfgMap;
                }
                case SSH_KEYPAIR: {
                    cfgMap.remove("repository.git.username");
                    cfgMap.remove("repository.git.password");
                    cfgMap.remove("repository.git.passwordCredentialsSource");
                    cfgMap.remove("repository.git.passwordSharedCredentials");
                    cfgMap.remove("repository.git.passwordSharedCredentials.scope");
                    String sshCredentialsSourceString = actionParametersMap.getString("repository.git.sshCredentialsSource");
                    cfgMap.put("repository.git.sshCredentialsSource", sshCredentialsSourceString);
                    switch (GitSshCredentialsSource.valueOf(sshCredentialsSourceString)) {
                        case SHARED_CREDENTIALS: {
                            cfgMap.remove("repository.git.ssh.key");
                            cfgMap.remove("repository.git.ssh.passphrase");
                            String sshSharedCredentialsId = actionParametersMap.getString("repository.git.sharedCredentials");
                            if (sshSharedCredentialsId == null) return cfgMap;
                            CredentialsData credentials = this.credentialsAccessor.getCredentials(Long.parseLong(sshSharedCredentialsId));
                            if (credentials != null && credentials.getProjectId() != null) {
                                cfgMap.put("repository.git.sharedCredentials.scope", SharedCredentialsScope.PROJECT.name());
                            }
                            cfgMap.put("repository.git.sharedCredentials.deleted", Boolean.toString(credentials == null));
                            cfgMap.put("repository.git.sharedCredentials", sshSharedCredentialsId);
                            break block23;
                        }
                        case CUSTOM: {
                            cfgMap.remove("repository.git.sharedCredentials");
                            cfgMap.remove("repository.git.sharedCredentials.scope");
                            if (actionParametersMap.getBoolean("temporary.git.ssh.key.change")) {
                                File keyFile = (File)actionParametersMap.getFiles().get("temporary.git.ssh.keyfile");
                                if (keyFile != null) {
                                    try {
                                        String key = FileUtils.readFileToString((File)keyFile);
                                        cfgMap.put("repository.git.ssh.key", key);
                                    }
                                    catch (IOException e) {
                                        log.error((Object)"Cannot read uploaded ssh key file", (Throwable)e);
                                    }
                                } else {
                                    cfgMap.remove("repository.git.ssh.key");
                                }
                            }
                            if (!actionParametersMap.getBoolean("temporary.git.ssh.passphrase.change")) return cfgMap;
                            cfgMap.put("repository.git.ssh.passphrase", actionParametersMap.getString("temporary.git.ssh.passphrase"));
                        }
                    }
                }
            }
        }
        return cfgMap;
    }

    private boolean credentialExists(long credentialId) {
        return this.credentialsAccessor.getCredentials(credentialId) != null;
    }

    public void addDefaultsForAdvancedOptions(Map<String, String> cfgMap) {
        cfgMap.put("repository.git.commandTimeout", Integer.toString(180));
        cfgMap.put("repository.git.useRemoteAgentCache", Boolean.TRUE.toString());
    }

    @NotNull
    public String getLocationIdentifier(@NotNull VcsLocationDefinition vcsLocationDefinition) {
        return (String)vcsLocationDefinition.getConfiguration().get("repository.git.repositoryUrl");
    }

    @NotNull
    public String getServerHost(@NotNull VcsLocationDefinition vcsLocationDefinition) {
        return "";
    }

    public Optional<VcsType> getScmType(@NotNull VcsLocationDefinition vcsLocationDefinition) {
        return Optional.of(VcsType.GIT);
    }
}

