/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.v2;

import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.agent.AgentTypeHolder;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.BuildLoggingContext;
import com.atlassian.bamboo.build.logger.NullBuildLogger;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.executor.CancelException;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.plan.branch.VcsBranchIntegrationHelper;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionData;
import com.atlassian.bamboo.plugins.git.GitCacheDirectory;
import com.atlassian.bamboo.plugins.git.GitOperationHelper;
import com.atlassian.bamboo.plugins.git.GitOperationHelperFactory;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.domain.HashAndSource;
import com.atlassian.bamboo.plugins.git.v2.AbstractGitExecutor;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.agent.capability.AgentContext;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.runtime.MergingVcsWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.NoContextVcsWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.StatusProvidingVcsWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.UpdatingVcsWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.VcsExecutorWithRequirements;
import com.atlassian.bamboo.vcs.runtime.VcsWorkingCopy;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitWorkingCopyManager
extends AbstractGitExecutor
implements MergingVcsWorkingCopyManager,
UpdatingVcsWorkingCopyManager,
NoContextVcsWorkingCopyManager,
StatusProvidingVcsWorkingCopyManager,
VcsExecutorWithRequirements {
    private static boolean USE_SHALLOW_CLONES = new SystemProperty(false, new String[]{"atlassian.bamboo.git.useShallowClones", "ATLASSIAN_BAMBOO_GIT_USE_SHALLOW_CLONES"}).getValue(true);
    private final BuildLoggerManager buildLoggerManager;
    private final VcsBranchIntegrationHelper branchIntegrationHelper;
    private final AgentContext agentContext;

    @Inject
    public GitWorkingCopyManager(CapabilityContext capabilityContext, CredentialsAccessor credentialsAccessor, CustomVariableContext customVariableContext, BuildDirectoryManager buildDirectoryManager, I18nResolver i18nResolver, TrustedKeyHelper trustedKeyHelper, SshProxyService sshProxyService, AgentContext agentContext, BuildLoggerManager buildLoggerManager, VcsBranchIntegrationHelper branchIntegrationHelper, BuildLoggingContext buildLoggingContext) {
        super(capabilityContext, credentialsAccessor, customVariableContext, buildDirectoryManager, i18nResolver, trustedKeyHelper, sshProxyService, buildLoggingContext);
        this.buildLoggerManager = buildLoggerManager;
        this.branchIntegrationHelper = branchIntegrationHelper;
        this.agentContext = agentContext;
    }

    @NotNull
    public VcsWorkingCopy getWorkingCopyInfo(@NotNull VcsRepositoryData repositoryData, @NotNull File checkoutPath) throws RepositoryException {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessDataBuilder(repositoryData).build();
        GitOperationHelper gitOperationHelper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)new NullBuildLogger(), this.i18nResolver, this.trustedKeyHelper);
        String currentRevision = gitOperationHelper.getCurrentRevision(checkoutPath);
        String currentBranch = gitOperationHelper.getCurrentBranch(checkoutPath);
        boolean isClean = gitOperationHelper.isClean(checkoutPath);
        return new VcsWorkingCopy(repositoryData.getId(), checkoutPath, currentRevision, !isClean, (VcsBranch)new VcsBranchImpl(currentBranch), !this.isSameBranch(currentBranch, substitutedAccessData));
    }

    @NotNull
    public Set<Requirement> getRequirements(@NotNull VcsRepositoryData vcsRepositoryData) {
        return Collections.emptySet();
    }

    private boolean isSameBranch(String currentBranch, GitRepositoryAccessData accessData) {
        if (currentBranch == null) {
            return true;
        }
        if (accessData.getVcsBranch().isEqualToBranchWith(currentBranch)) {
            return true;
        }
        return accessData.getVcsBranch().getName().startsWith("refs/heads/") && accessData.getVcsBranch().getName().substring("refs/heads/".length()).equals(currentBranch);
    }

    private boolean shouldUseCache(@NotNull GitRepositoryAccessData substitutedAccessData) {
        return substitutedAccessData.isUseAgentCache() || this.agentContext.getBuildAgent() == null;
    }

    @NotNull
    public VcsWorkingCopy retrieveSourceCode(@NotNull CommonContext commonContext, @NotNull VcsRepositoryData repositoryData, @NotNull PlanVcsRevisionData targetRevision, @NotNull File targetPath) throws RepositoryException {
        return this.checkout(commonContext, repositoryData, targetRevision, targetPath, false);
    }

    @NotNull
    public VcsWorkingCopy updateToLatestRevision(@NotNull CommonContext commonContext, @NotNull VcsRepositoryData repositoryData, @NotNull File targetPath) throws RepositoryException {
        return this.checkout(commonContext, repositoryData, null, targetPath, false);
    }

    @NotNull
    public VcsWorkingCopy updateToLatestRevision(@NotNull VcsRepositoryData repositoryData, @NotNull File targetPath) throws RepositoryException {
        return this.checkout(null, repositoryData, null, targetPath, false);
    }

    @NotNull
    public VcsWorkingCopy updateToLatestRevisionForSpecs(@NotNull VcsRepositoryData repositoryData, @NotNull File targetPath) throws RepositoryException {
        return this.checkout(null, repositoryData, null, targetPath, false, SystemProperty.FETCHING_LFS_FILES_ON_SERVER_ENABLED.getTypedValue());
    }

    @NotNull
    public VcsWorkingCopy checkoutAndMerge(@NotNull CommonContext commonContext, @NotNull VcsRepositoryData vcsRepositoryData, @NotNull VcsBranch targetBranch, @NotNull PlanVcsRevisionData revisionOnTarget, @NotNull VcsBranch sourceBranch, @NotNull PlanVcsRevisionData sourceRevision, @NotNull File targetPath) throws RepositoryException {
        PlanVcsRevisionData tmp = new PlanVcsRevisionData(revisionOnTarget.getVcsRevisionKey(), revisionOnTarget.getCustomXmlData(), targetBranch);
        this.checkout(commonContext, vcsRepositoryData, tmp, targetPath, true);
        BuildLogger buildLogger = this.buildLoggerManager.getLogger(commonContext.getResultKey());
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessDataBuilder(vcsRepositoryData).branch((VcsBranch)new VcsBranchImpl(this.substituteString(sourceBranch.getName()))).useShallowClones(false).build();
        GitOperationHelper connector = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, buildLogger, this.i18nResolver, this.trustedKeyHelper);
        File cacheDirectory = this.getCacheDirectory(substitutedAccessData);
        HashAndSource hashAndSource = HashAndSource.hashAndBranch(sourceRevision.getVcsRevisionKey(), substitutedAccessData.getVcsBranch().getName());
        try {
            if (this.shouldUseCache(substitutedAccessData)) {
                GitCacheDirectory.getCacheLock(cacheDirectory).withLock(() -> {
                    this.fetchCacheWithRetry(connector, cacheDirectory, hashAndSource, buildLogger, true, true);
                    return null;
                });
                connector.checkRevisionExistsInCacheRepository(cacheDirectory, sourceRevision.getVcsRevisionKey());
            } else {
                this.fetchWithRetry(connector, targetPath, hashAndSource, buildLogger, false);
            }
        }
        catch (CancelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException(this.i18nResolver.getText("repository.git.messages.runtimeException"), (Throwable)e);
        }
        Pair<Boolean, String> result = connector.mergeAndReturnHead(targetPath, revisionOnTarget.getVcsRevisionKey(), sourceRevision.getVcsRevisionKey(), this.branchIntegrationHelper.getCommitterName(), this.branchIntegrationHelper.getCommitterEmail());
        return new VcsWorkingCopy(vcsRepositoryData.getId(), targetPath, (String)result.getSecond(), ((Boolean)result.getFirst()).booleanValue());
    }

    @NotNull
    private VcsWorkingCopy checkout(@Nullable CommonContext commonContext, @NotNull VcsRepositoryData repositoryData, @Nullable PlanVcsRevisionData planVcsRevisionData, @NotNull File sourceDirectory, boolean needsDeepClone) throws RepositoryException {
        return this.checkout(commonContext, repositoryData, planVcsRevisionData, sourceDirectory, needsDeepClone, true);
    }

    @NotNull
    private VcsWorkingCopy checkout(@Nullable CommonContext commonContext, @NotNull VcsRepositoryData repositoryData, @Nullable PlanVcsRevisionData planVcsRevisionData, @NotNull File sourceDirectory, boolean needsDeepClone, boolean fetchLfsFiles) throws RepositoryException {
        String vcsRevisionKey = null;
        VcsBranch effectiveBranch = null;
        if (planVcsRevisionData != null) {
            vcsRevisionKey = planVcsRevisionData.getVcsRevisionKey();
            effectiveBranch = planVcsRevisionData.getActualBranch();
        }
        try {
            VcsBranch vcsBranch;
            boolean doShallowFetch;
            GitRepositoryAccessData accessData = this.getAccessData(repositoryData);
            GitRepositoryAccessData.Builder substitutedAccessDataBuilder = this.getSubstitutedAccessDataBuilder(repositoryData);
            BuildLogger buildLogger = this.getBuildLogger(commonContext);
            if (planVcsRevisionData != null && StringUtils.contains((CharSequence)planVcsRevisionData.getCustomXmlData(), (CharSequence)"fetchAll")) {
                substitutedAccessDataBuilder.shouldFetchAllRefs(true);
                buildLogger.addBuildLogEntry("Enforcing full fetch as requested revision has not been found on the configured branch");
            }
            boolean bl = doShallowFetch = USE_SHALLOW_CLONES && accessData.isUseShallowClones() && !this.isOnLocalAgent() && effectiveBranch == null && !needsDeepClone;
            if (effectiveBranch != null) {
                substitutedAccessDataBuilder.branch(effectiveBranch);
            }
            substitutedAccessDataBuilder.useShallowClones(doShallowFetch);
            GitRepositoryAccessData substitutedAccessData = substitutedAccessDataBuilder.build();
            GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, buildLogger, this.i18nResolver, this.trustedKeyHelper);
            HashAndSource hashAndSource = vcsRevisionKey != null ? HashAndSource.hashAndBranch(vcsRevisionKey, (vcsBranch = substitutedAccessData.getVcsBranch()) != null ? vcsBranch.getName() : vcsRevisionKey) : helper.obtainLatestRevision();
            String previousRevision = helper.getShaOfRefIfExists(sourceDirectory, "HEAD");
            if (this.shouldUseCache(substitutedAccessData)) {
                File cacheDirectory = this.getCacheDirectory(substitutedAccessData);
                String returnedRevision = (String)GitCacheDirectory.getCacheLock(cacheDirectory).withLock(() -> {
                    this.fetchCacheWithRetry(helper, cacheDirectory, hashAndSource, buildLogger, true, fetchLfsFiles);
                    helper.checkRevisionExistsInCacheRepository(cacheDirectory, hashAndSource.getHash());
                    try {
                        return helper.checkout(cacheDirectory, sourceDirectory, hashAndSource.getHash(), previousRevision, fetchLfsFiles);
                    }
                    catch (CancelException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        this.rethrowOrRemoveDirectory(e, helper, buildLogger, sourceDirectory, "repository.git.messages.rsRecover.failedToCheckout");
                        buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.rsRecover.cleanedSourceDirectory", new Serializable[]{sourceDirectory}));
                        String returnRevision = helper.checkout(cacheDirectory, sourceDirectory, hashAndSource.getHash(), null, fetchLfsFiles);
                        buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.rsRecover.checkoutCompleted"));
                        return returnRevision;
                    }
                });
                return new VcsWorkingCopy(repositoryData.getId(), sourceDirectory, returnedRevision);
            }
            this.fetchWithRetry(helper, sourceDirectory, hashAndSource, buildLogger, doShallowFetch);
            try {
                return new VcsWorkingCopy(repositoryData.getId(), sourceDirectory, helper.checkout(null, sourceDirectory, hashAndSource.getHash(), previousRevision));
            }
            catch (CancelException e) {
                throw e;
            }
            catch (Exception e) {
                this.rethrowOrRemoveDirectory(null, helper, buildLogger, sourceDirectory, "repository.git.messages.rsRecover.failedToCheckout");
                buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.rsRecover.cleanedSourceDirectory", new Serializable[]{sourceDirectory}));
                this.fetchWithRetry(helper, sourceDirectory, hashAndSource, buildLogger, false);
                buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.rsRecover.fetchingCompleted", new Serializable[]{sourceDirectory}));
                String returnRevision = helper.checkout(null, sourceDirectory, hashAndSource.getHash(), null);
                buildLogger.addBuildLogEntry(this.i18nResolver.getText("repository.git.messages.rsRecover.checkoutCompleted"));
                return new VcsWorkingCopy(repositoryData.getId(), sourceDirectory, returnRevision);
            }
        }
        catch (CancelException | RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException(this.i18nResolver.getText("repository.git.messages.runtimeException"), (Throwable)e);
        }
    }

    @NotNull
    private BuildLogger getBuildLogger(@Nullable CommonContext commonContext) {
        return commonContext != null ? this.buildLoggerManager.getLogger(commonContext.getResultKey()) : new NullBuildLogger();
    }

    public void stageChanges(@NotNull VcsWorkingCopy workingCopy, @NotNull VcsRepositoryData repositoryData, @NotNull Collection<String> pathsToAdd) throws RepositoryException {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(repositoryData);
        GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)new NullBuildLogger(), this.i18nResolver, this.trustedKeyHelper);
        helper.stageChanges(workingCopy.getPath(), pathsToAdd);
    }

    @NotNull
    public VcsWorkingCopy commitLocal(@NotNull VcsWorkingCopy workingCopy, @NotNull VcsRepositoryData vcsRepositoryData, @NotNull String commitMessage) throws RepositoryException {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(vcsRepositoryData);
        GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)new NullBuildLogger(), this.i18nResolver, this.trustedKeyHelper);
        String commitHash = helper.commit(workingCopy.getPath(), commitMessage, this.branchIntegrationHelper.getCommitterName(), this.branchIntegrationHelper.getCommitterEmail());
        return new VcsWorkingCopy(workingCopy.getRepositoryId(), workingCopy.getPath(), commitHash, workingCopy.getCurrentBranch(), workingCopy.isCurrentBranchChanged());
    }

    @NotNull
    public VcsWorkingCopy updateRemote(@NotNull VcsWorkingCopy workingCopy, @NotNull VcsRepositoryData vcsRepositoryData, @Nullable String commitMessage) throws RepositoryException {
        GitRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(vcsRepositoryData);
        GitOperationHelper helper = GitOperationHelperFactory.createGitOperationHelper(this, substitutedAccessData, this.sshProxyService, (BuildLogger)new NullBuildLogger(), this.i18nResolver, this.trustedKeyHelper);
        helper.pushRevision(workingCopy.getPath(), workingCopy.getCurrentRevisionKey(), workingCopy.getCurrentBranch() != null ? workingCopy.getCurrentBranch().getName() : null);
        return workingCopy;
    }

    private boolean isOnLocalAgent() {
        return AgentTypeHolder.get() == AgentType.LOCAL;
    }
}

